/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.utils;

import java.util.HashMap;
import org.jkiss.code.NotNull;

public final class FFMetadataUtils {
    public static final String DEFAULT_COLUMN_NAME_PREFIX = "column";

    private FFMetadataUtils() {
    }

    @NotNull
    public static String normalizeObjectName(@NotNull String tableName) {
        StringBuilder out = new StringBuilder(tableName.length());
        int i = 0;
        while (i < tableName.length()) {
            char ch = tableName.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': 
                case '`': {
                    out.append('_');
                    break;
                }
                default: {
                    out.append(ch);
                }
            }
            ++i;
        }
        return out.toString();
    }

    @NotNull
    public static String[] generateColumnNames(int count) {
        String[] columnNames = new String[count];
        int i = 0;
        while (i < count) {
            columnNames[i] = "column_" + (i + 1);
            ++i;
        }
        return columnNames;
    }

    @NotNull
    public static String[] normalizeColumnNames(@NotNull String[] names) {
        String[] trimmedNames = new String[names.length];
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            trimmedNames[i] = name == null || name.isBlank() ? "column_" + (i + 1) : name.trim();
            ++i;
        }
        return FFMetadataUtils.deduplicateColumnNames(trimmedNames);
    }

    @NotNull
    private static String[] deduplicateColumnNames(@NotNull String[] headers) {
        HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
        String[] result = new String[headers.length];
        int i = 0;
        while (i < headers.length) {
            String name = headers[i];
            String lowerName = name.toLowerCase();
            if (!nameCount.containsKey(lowerName)) {
                nameCount.put(lowerName, 1);
                result[i] = name;
            } else {
                int count = (Integer)nameCount.get(lowerName);
                String newName = name + "_" + count;
                String lowerNewName = newName.toLowerCase();
                while (nameCount.containsKey(lowerNewName)) {
                    newName = name + "_" + ++count;
                    lowerNewName = newName.toLowerCase();
                }
                result[i] = newName;
                nameCount.put(lowerName, count + 1);
                nameCount.put(lowerNewName, 1);
            }
            ++i;
        }
        return result;
    }
}

