/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import com.dbeaver.jdbc.upd.protocol.UPDArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.SQLException;

public class UPDArrayAdapter
implements JsonSerializer<UPDArray>,
JsonDeserializer<UPDArray> {
    public JsonElement serialize(UPDArray src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("baseTypeName", src.getBaseTypeName());
            json.addProperty("baseType", (Number)src.getBaseType());
            json.add("values", context.serialize(src.getArray()));
            return json;
        }
        catch (SQLException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public UPDArray deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String baseTypeName = jsonObject.get("baseTypeName").getAsString();
        int baseType = jsonObject.get("baseType").getAsInt();
        Object[] values = (Object[])context.deserialize(jsonObject.get("values"), Object[].class);
        return new UPDArray(baseTypeName, baseType, values);
    }
}

