/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag;

import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.RAGStorageProvider;
import com.dbeaver.model.ai.rag.AIScopeSelector;
import com.dbeaver.model.ai.rag.NoOpScopeSelector;
import com.dbeaver.model.ai.rag.RAGIndexBuilder;
import com.dbeaver.model.ai.rag.RAGObjectDescriber;
import com.dbeaver.model.ai.rag.RAGScopeSelector;
import com.dbeaver.model.ai.rag.strategy.CustomScopeSelectionStrategy;
import com.dbeaver.model.ai.rag.strategy.GeneralSelectionStrategy;
import com.dbeaver.model.ai.rag.strategy.SelectionStrategy;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.impl.AISchemaGeneratorImpl;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPWorkspace;

public class AIScopeSelectorFactory {
    private static final Log log = Log.getLog(AIScopeSelectorFactory.class);
    @NotNull
    private final DBPWorkspace workspace;
    @NotNull
    private final AISchemaGeneratorImpl schemaGenerator = new AISchemaGeneratorImpl();
    @NotNull
    private static final AtomicReference<AIScopeSelector> CACHED_SCOPE_SELECTOR = new AtomicReference();
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(4, r -> {
        Thread thread = new Thread(r);
        thread.setName("ai-scope-selector-worker" + thread.threadId());
        thread.setDaemon(true);
        return thread;
    });

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(EXECUTOR_SERVICE::shutdownNow));
    }

    public AIScopeSelectorFactory(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
    }

    public AIScopeSelector getScopeSelector() {
        return CACHED_SCOPE_SELECTOR.updateAndGet(existing -> {
            if (existing != null) {
                return existing;
            }
            return this.createScopeSelector();
        });
    }

    @NotNull
    private AIScopeSelector createScopeSelector() {
        DBPApplication dBPApplication = this.workspace.getPlatform().getApplication();
        if (dBPApplication instanceof RAGStorageProvider) {
            RAGStorageProvider ragStorageProvider = (RAGStorageProvider)dBPApplication;
            try {
                RAGEmbeddingStorage embeddingStorage = ragStorageProvider.getEmbeddingStorage();
                RAGIndexBuilder indexBuilder = new RAGIndexBuilder(embeddingStorage, new RAGObjectDescriber((AISchemaGenerator)this.schemaGenerator), EXECUTOR_SERVICE);
                Map<AIDatabaseScope, SelectionStrategy> strategyMap = Map.of(AIDatabaseScope.CURRENT_SCHEMA, new GeneralSelectionStrategy(embeddingStorage), AIDatabaseScope.CURRENT_DATABASE, new GeneralSelectionStrategy(embeddingStorage), AIDatabaseScope.CURRENT_DATASOURCE, new GeneralSelectionStrategy(embeddingStorage), AIDatabaseScope.CUSTOM, new CustomScopeSelectionStrategy(embeddingStorage));
                return new RAGScopeSelector(indexBuilder, strategyMap);
            }
            catch (Exception e) {
                log.error((Object)"Error initializing RAG scope selector", (Throwable)e);
                return new NoOpScopeSelector();
            }
        }
        log.info((Object)"RAG is not available in the current application. Using NoOpScopeSelector.");
        return new NoOpScopeSelector();
    }
}

