/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage.sqlite;

import com.dbeaver.model.ai.rag.storage.RAGDatabaseExtensionsInitializer;
import com.dbeaver.model.ai.rag.storage.sqlite.SQLiteExtension;
import com.dbeaver.model.ai.rag.storage.sqlite.VecExtension;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;

public class RAGSQLiteExtensionsInitializer
implements RAGDatabaseExtensionsInitializer {
    private final List<SQLiteExtension> extensions = List.of(new VecExtension());

    @Override
    public void initializeExtensions(@NotNull DBPDriver driver, @NotNull Connection connection) throws DBException {
        for (SQLiteExtension extension : this.extensions) {
            try {
                if (extension.isLoaded(connection)) continue;
                extension.loadExtension(driver, connection);
            }
            catch (DBException e) {
                throw new DBException("Error loading SQLite extension: " + extension.name(), (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public Map<Object, Object> getConnectionProperties(@NotNull String driver) {
        return Map.of("enable_load_extension", "true");
    }
}

