/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai;

import com.dbeaver.model.ai.AIAssistantPro;
import com.dbeaver.model.ai.AIChatContextProvider;
import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.model.ai.AIChatRequest;
import com.dbeaver.model.ai.AIChatResponseConsumer;
import com.dbeaver.model.ai.QMAIChatHistoryMapper;
import com.dbeaver.model.qm.ai.QMAIChatStorage;
import com.dbeaver.model.qm.ai.QMAIConversationHistory;
import com.dbeaver.model.qm.ai.QMAIDataSource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantRegistry;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.LazyValue;

public class AIChatSession {
    private static final Log log = Log.getLog(AIChatSession.class);
    private final Map<UUID, Long> conversationToContextChecksum = new WeakHashMap<UUID, Long>();
    private final List<AIChatListener> listeners = new ArrayList<AIChatListener>();
    private final DBPWorkspace workspace;
    private final AIChatContextProvider contextProvider;
    private final LazyValue<QMAIChatStorage, DBException> storage;
    private final SessionIdProvider sessionIdProvider;
    private Map<UUID, AIChatConversation> conversations;
    private boolean busy;
    private AIAssistantPro assistant;
    private volatile boolean initialized = false;
    private volatile AbstractJob aiJob;

    public AIChatSession(@NotNull DBPWorkspace workspace, @NotNull AIChatContextProvider contextProvider, final @NotNull LazyValue<QMAIChatStorage, DBException> storage, @NotNull SessionIdProvider sessionIdProvider) {
        this.workspace = workspace;
        this.contextProvider = contextProvider;
        this.storage = storage;
        this.sessionIdProvider = sessionIdProvider;
        this.addListener(new AIChatListener(){

            @Override
            public void messageAdded(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                RuntimeUtils.runTask(monitor -> {
                    try {
                        AIChatSession.this.saveConversation(monitor, conversation);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error appending message to chat storage", (Throwable)e);
                    }
                }, (String)"Save AI conversation", (long)10000L);
            }

            @Override
            public void messageRemoved(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                if (conversation.isTemporary()) {
                    return;
                }
                try {
                    ((QMAIChatStorage)storage.getInstance()).deleteMessage(conversation.getId().toString(), message.id());
                }
                catch (DBException e) {
                    log.error((Object)"Error appending message to chat storage", (Throwable)e);
                }
            }

            @Override
            public void conversationRenamed(@NotNull AIChatConversation conversation, @NotNull String newName) {
                if (conversation.isTemporary()) {
                    return;
                }
                try {
                    ((QMAIChatStorage)storage.getInstance()).renameConversation(conversation.getId().toString(), newName);
                }
                catch (DBException e) {
                    log.error((Object)"Error renaming conversation", (Throwable)e);
                }
            }
        });
    }

    private void saveConversation(@NotNull DBRProgressMonitor monitor, @NotNull AIChatConversation conversation) throws DBException {
        if (conversation.isTemporary()) {
            return;
        }
        AIContextSettings contextSettings = this.getConversationSettings(conversation);
        AIDatabaseContext databaseContext = contextSettings == null ? null : this.createDatabaseContext(monitor, contextSettings);
        ((QMAIChatStorage)this.storage.getInstance()).saveConversation(this.sessionIdProvider.getSessionId(monitor), QMAIChatHistoryMapper.toQMAIChatHistory(conversation, contextSettings, databaseContext));
    }

    @Nullable
    public AIContextSettings getConversationSettings(@NotNull AIChatConversation conversation) {
        DBPDataSourceContainer dataSource = conversation.getDataSource();
        if (dataSource == null) {
            return null;
        }
        AICompletionSettings dataSourceSettings = new AICompletionSettings(dataSource);
        AIChatConversationSettings customSettings = conversation.getCustomSettings();
        if (customSettings != null && !dataSourceSettings.equalsSettings((AIContextSettings)customSettings)) {
            return customSettings;
        }
        return dataSourceSettings;
    }

    public void init() throws DBException {
        if (this.initialized) {
            return;
        }
        RuntimeUtils.runTask(monitor -> {
            try {
                this.conversations = new LinkedHashMap<UUID, AIChatConversation>();
                List conversationsHistory = ((QMAIChatStorage)this.storage.getInstance()).findConversations(this.sessionIdProvider.getSessionId(monitor));
                for (QMAIConversationHistory history : conversationsHistory) {
                    DBPDataSourceContainer dataSourceContainer = this.getContainer(history.getDataSource());
                    AIChatConversation conversation = QMAIChatHistoryMapper.toAIChatConversation(history, dataSourceContainer);
                    String contextJson = history.getContext().getContextJson();
                    if (contextJson != null) {
                        AIChatConversationSettings convSettings = new AIChatConversationSettings(this, conversation);
                        convSettings.loadSettingsFromString(contextJson);
                        convSettings.loadDataSourceDefaults();
                        conversation.setCustomSettings(convSettings);
                    }
                    this.conversations.put(conversation.getId(), conversation);
                }
                this.initialized = true;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }, (String)"Initialize AI chat session", (long)10000L);
    }

    @Nullable
    public AIChatConversation getLastConversation(@Nullable DBPDataSourceContainer container) throws DBException {
        this.init();
        AIChatConversation lastConversation = null;
        for (AIChatConversation conversation : this.conversations.values()) {
            if (conversation.getDataSource() != container || lastConversation != null && !conversation.getLastMessageTime().isAfter(lastConversation.getLastMessageTime())) continue;
            lastConversation = conversation;
        }
        return lastConversation;
    }

    public void addConversation(@NotNull AIChatConversation conversation) throws DBException {
        this.init();
        this.conversations.put(conversation.getId(), conversation);
    }

    public void removeConversation(@NotNull AIChatConversation conversation) throws DBException {
        this.init();
        this.conversations.remove(conversation.getId());
        if (conversation.isTemporary()) {
            return;
        }
        ((QMAIChatStorage)this.storage.getInstance()).deleteConversation(conversation.getId().toString());
    }

    @Nullable
    public AIChatConversation getConversation(@NotNull String id) throws DBException {
        return this.getConversation(UUID.fromString(id));
    }

    @Nullable
    public AIChatConversation getConversation(@NotNull UUID id) throws DBException {
        this.init();
        return this.conversations.get(id);
    }

    @NotNull
    public List<AIChatConversation> getAllConversations(@Nullable DBPDataSourceContainer container) throws DBException {
        this.init();
        return this.conversations.values().stream().filter(it -> it.getDataSource() == container).sorted(Comparator.comparing(AIChatConversation::getLastMessageTime).reversed()).toList();
    }

    @NotNull
    public Set<DBPDataSourceContainer> getAllDataSources() throws DBException {
        this.init();
        LinkedHashSet<DBPDataSourceContainer> dsList = new LinkedHashSet<DBPDataSourceContainer>();
        for (AIChatConversation conversation : this.conversations.values()) {
            if (conversation.getDataSource() == null) continue;
            dsList.add(conversation.getDataSource());
        }
        return dsList;
    }

    public void addListener(@NotNull AIChatListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull AIChatListener listener) {
        this.listeners.remove(listener);
    }

    public <T> void notifyListeners(@NotNull BiConsumer<AIChatListener, T> consumer, T payload) {
        AIChatListener[] aIChatListenerArray = (AIChatListener[])this.listeners.toArray(AIChatListener[]::new);
        int n = aIChatListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIChatListener listener = aIChatListenerArray[n2];
            consumer.accept(listener, (AIChatListener)payload);
            ++n2;
        }
    }

    public void notifyMessageAdd(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
        this.notifyListeners((aiChatListener, message1) -> aiChatListener.messageAdded(conversation, (AIChatMessage)message1), message);
    }

    public void notifyMessageRemove(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
        int index = conversation.getMessages().indexOf(message);
        if (index >= 0) {
            this.notifyMessagesRemove(conversation, conversation.getMessages().subList(index, index + 1));
        }
        conversation.removeMessage(message);
    }

    public void notifyConversationRenamed(@NotNull AIChatConversation conversation, @NotNull String newName) {
        this.notifyListeners((aiChatListener, message) -> aiChatListener.conversationRenamed(conversation, newName), newName);
    }

    public void notifyMessagesRemove(@NotNull AIChatConversation conversation) {
        this.notifyMessagesRemove(conversation, conversation.getMessages());
    }

    public void notifyMessagesRemove(@NotNull AIChatConversation conversation, @NotNull AIChatMessage afterInclusive) {
        int index = conversation.getMessages().indexOf(afterInclusive);
        if (index >= 0) {
            this.notifyMessagesRemove(conversation, conversation.getMessages().subList(index, conversation.getMessages().size()));
        }
    }

    private void notifyMessagesRemove(@NotNull AIChatConversation conversation, @NotNull List<AIChatMessage> view) {
        int i = view.size();
        while (i > 0) {
            this.notifyListeners((aiChatListener, message) -> aiChatListener.messageRemoved(conversation, (AIChatMessage)message), view.get(i - 1));
            --i;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        if (this.busy != busy) {
            this.busy = busy;
            this.notifyListeners(AIChatListener::busyChanged, busy);
        }
    }

    public AIAssistantPro getAssistant() {
        if (this.assistant == null) {
            this.assistant = (AIAssistantPro)AIAssistantRegistry.getInstance().createAssistant(this.workspace);
        }
        return this.assistant;
    }

    public void saveConversationSettings(@NotNull DBRProgressMonitor monitor, @NotNull AIChatConversation conversation) throws DBException {
        this.saveConversation(monitor, conversation);
    }

    public boolean isRunning() {
        return this.aiJob != null;
    }

    @NotNull
    public synchronized CompletableFuture<List<AIMessage>> submitConversation(final @Nullable AIContextSettings settings, final @NotNull AIChatConversation conversation) {
        if (this.aiJob != null) {
            return CompletableFuture.failedFuture(new DBException("Previous AI completion is already running"));
        }
        try {
            if (!AIUtils.hasValidConfiguration()) {
                return CompletableFuture.failedFuture(new DBException("Invalid AI engine configuration"));
            }
            CompletableFuture<List<AIMessage>> future = new CompletableFuture<List<AIMessage>>();
            final AIChatResponseConsumer subscriber = AIChatSession.getAiEngineResponseChunkSubscriber(future);
            this.aiJob = new AbstractJob("AI completion"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        try {
                            AIChatSession.this.processAICompletion(monitor, conversation, subscriber, settings);
                        }
                        catch (Throwable e) {
                            subscriber.error(e);
                            AIChatSession.this.aiJob = null;
                        }
                    }
                    finally {
                        AIChatSession.this.aiJob = null;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.aiJob.schedule();
            return future;
        }
        catch (DBException e) {
            return CompletableFuture.failedFuture(new DBException("Cannot determine AI engine", (Throwable)e));
        }
    }

    private static AIChatResponseConsumer getAiEngineResponseChunkSubscriber(final @NotNull CompletableFuture<List<AIMessage>> future) {
        return new AIChatResponseConsumer(){
            final StringBuilder response = new StringBuilder();
            final List<AIMessage> messages = new ArrayList<AIMessage>();

            @Override
            public void nextMessageChunk(@NotNull String item) {
                this.response.append(item);
            }

            @Override
            public void nextFunctionCall(@NotNull AIFunctionCall functionCall, @NotNull AIFunctionResult result) {
                if (functionCall.getFunction() != null && functionCall.getFunction().getType() == AIFunctionResult.FunctionType.ACTION) {
                    future.complete(List.of(AIMessage.functionCall((AIFunctionCall)functionCall, (AIFunctionResult)result)));
                }
            }

            @Override
            public void warning(@NotNull String message) {
                this.messages.add(AIMessage.warningMessage((String)message));
            }

            @Override
            public void error(@NotNull Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            @Override
            public void close() {
                this.messages.add(AIMessage.assistantMessage((String)this.response.toString()));
                future.complete(this.messages);
            }
        };
    }

    public void cancelAICompletion() {
        AbstractJob job = this.aiJob;
        if (job != null) {
            job.cancel();
        }
    }

    public void processAICompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIChatConversation conversation, @NotNull AIChatResponseConsumer chatListener, @Nullable AIContextSettings settings) throws DBException {
        AIDatabaseContext context;
        AIDatabaseContext aIDatabaseContext = context = settings == null ? null : this.createDatabaseContext(monitor, settings);
        if (this.isContextChanged(conversation.getId(), context) && !conversation.isTemporary()) {
            ((QMAIChatStorage)this.storage.getInstance()).saveConversation(this.sessionIdProvider.getSessionId(monitor), QMAIChatHistoryMapper.toQMAIChatHistory(conversation, settings, context));
        }
        AIChatRequest request = new AIChatRequest(context, conversation.getMessages().stream().map(AIChatMessage::message).filter(m -> !m.getRole().isLocal()).toList());
        this.getAssistant().generateTextStream(monitor, request.context(), conversation.getPromptGenerator(), request.messages(), chatListener);
    }

    @Nullable
    private AIDatabaseContext createDatabaseContext(@NotNull DBRProgressMonitor monitor, @NotNull AIContextSettings settings) throws DBException {
        Object[] customObjectIds;
        DBPDataSource dataSource;
        DBPDataSourceContainer container = settings.getDataSourceContainer();
        if (container == null) {
            return null;
        }
        if (!container.isConnected()) {
            container.connect(monitor, true, true);
        }
        DBCExecutionContext executionContext = this.contextProvider.getExecutionContext(container);
        DBSLogicalDataSource lDataSource = DBSLogicalDataSource.createLogicalDataSource((DBPDataSourceContainer)container, (DBCExecutionContext)executionContext);
        this.updateScopeSettingsIfNeeded(settings, container);
        assert (settings.getScope() != null);
        AIDatabaseContext.Builder builder = new AIDatabaseContext.Builder(lDataSource).setScope(settings.getScope());
        if (executionContext != null) {
            builder.setExecutionContext(executionContext);
        }
        if (settings.getScope() == AIDatabaseScope.CUSTOM && (dataSource = container.getDataSource()) != null && !ArrayUtils.isEmpty((Object[])(customObjectIds = settings.getCustomObjectIds()))) {
            LinkedHashSet idSet = new LinkedHashSet();
            Collections.addAll(idSet, customObjectIds);
            builder.setCustomEntities(AITextUtils.loadCustomEntities((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, idSet));
        }
        return builder.build();
    }

    public void updateScopeSettingsIfNeeded(@NotNull AIContextSettings settings, @NotNull DBPDataSourceContainer container) {
        if (settings.getScope() != null || !container.isConnected()) {
            return;
        }
        DBCExecutionContext executionContext = this.contextProvider.getExecutionContext(container);
        AIUtils.updateScopeSettingsIfNeeded((AIContextSettings)settings, (DBPDataSourceContainer)container, (DBCExecutionContext)executionContext);
    }

    private boolean isContextChanged(@NotNull UUID conversationId, @Nullable AIDatabaseContext context) {
        long checksum;
        Long prevChecksum;
        if (context == null) {
            return false;
        }
        CRC32 crc32 = new CRC32();
        crc32.update(context.getScope().name().getBytes());
        if (context.getScope() == AIDatabaseScope.CUSTOM && context.getCustomEntities() != null) {
            context.getCustomEntities().stream().filter(Objects::nonNull).map(it -> it.getName().getBytes()).forEach(crc32::update);
        }
        return (prevChecksum = this.conversationToContextChecksum.put(conversationId, checksum = crc32.getValue())) == null || prevChecksum != checksum;
    }

    @Nullable
    private DBPDataSourceContainer getContainer(@Nullable QMAIDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        DBPProject project = this.workspace.getProjectById(dataSource.projectId());
        if (project == null) {
            return null;
        }
        return project.getDataSourceRegistry().getDataSource(dataSource.dataSourceId());
    }

    public static interface SessionIdProvider {
        @NotNull
        public String getSessionId(DBRProgressMonitor var1) throws DBException;
    }
}

