/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio;

import com.dbeaver.model.ai.audio.AIAudioStream;
import com.dbeaver.model.ai.audio.processing.AudioSink;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiPredicate;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public class AIAudioRecorder
extends SubmissionPublisher<ByteBuffer> {
    private static final Log log = Log.getLog(AIAudioRecorder.class);
    public static final ByteBuffer RESET_SIGNAL = ByteBuffer.allocate(0);
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 1, true, false);
    public static final int PCM16_MAX = Short.MAX_VALUE;
    public static final float PCM16_NORMALIZATION = 32768.0f;
    public static final int BUFFER_MILLIS = (int)Duration.ofMillis(100L).toMillis();
    private static final long READ_BACKOFF_NS = Duration.ofMillis(1L).toNanos();
    private static final long PAUSE_BACKOFF_NS = Duration.ofMillis(5L).toNanos();
    private static final int PACKET_MILLIS = 10;
    private final AudioFormat format;
    private final int bufferSize;
    private final int frameSize;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final ExecutorService executorService;
    private final int packetBytes;
    private volatile TargetDataLine activeLine;
    private volatile Thread readerThread;
    private final AudioSink sink;
    private Future<?> timeoutJob;
    private CompletableFuture<AIAudioStream> result;

    public AIAudioRecorder(@NotNull AudioFormat format, @NotNull AudioSink sink, @NotNull Executor executor) {
        this(format, BUFFER_MILLIS, sink, executor);
    }

    public AIAudioRecorder(@NotNull AudioFormat format, int bufferMillis, @NotNull AudioSink sink, @NotNull Executor executor) {
        super(executor, 1024);
        this.format = format;
        this.frameSize = format.getFrameSize();
        this.bufferSize = (int)(format.getFrameRate() * (float)this.frameSize * (float)bufferMillis / 1000.0f);
        this.sink = sink;
        int packetFrames = Math.max(1, Math.round(Math.max(1.0f, format.getFrameRate()) * 10.0f / 1000.0f));
        this.packetBytes = Math.max(this.frameSize, packetFrames * this.frameSize);
        this.executorService = Executors.newFixedThreadPool(1, r -> {
            Thread t = new Thread(r, "audio-exec");
            t.setDaemon(true);
            return t;
        });
    }

    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.result = this.sink.beginNewCapture();
        this.executorService.execute(() -> {
            block31: {
                this.readerThread = Thread.currentThread();
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (TargetDataLine line = AudioSystem.getTargetDataLine(this.format);){
                            int avail;
                            this.activeLine = line;
                            line.open(this.format);
                            line.start();
                            ByteBuffer readBuf = ByteBuffer.allocate(this.bufferSize);
                            ByteBuffer combo = ByteBuffer.allocate(this.bufferSize * 2);
                            byte[] leftover = new byte[this.packetBytes];
                            int leftoverLen = 0;
                            while (this.running.get()) {
                                if (this.paused.get()) {
                                    if (line.isRunning()) {
                                        line.stop();
                                    }
                                    while (this.paused.get() && this.running.get()) {
                                        LockSupport.parkNanos(PAUSE_BACKOFF_NS);
                                    }
                                    if (this.running.get() && !line.isRunning()) {
                                        line.start();
                                    }
                                }
                                readBuf.clear();
                                int read = line.read(readBuf.array(), 0, readBuf.capacity());
                                if (read <= 0) {
                                    LockSupport.parkNanos(READ_BACKOFF_NS);
                                    continue;
                                }
                                leftoverLen = this.sliceAndOffer(combo, leftover, leftoverLen, readBuf, read);
                            }
                            LockSupport.parkNanos(READ_BACKOFF_NS);
                            while ((avail = line.available()) > 0) {
                                int toRead = Math.min(avail, readBuf.capacity());
                                readBuf.clear();
                                int read = line.read(readBuf.array(), 0, toRead);
                                if (read <= 0) {
                                    break;
                                }
                                leftoverLen = this.sliceAndOffer(combo, leftover, leftoverLen, readBuf, read);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        this.closeExceptionally(e);
                        if (this.timeoutJob != null && !this.timeoutJob.isDone()) {
                            this.timeoutJob.cancel(true);
                            this.timeoutJob = null;
                        }
                        try {
                            this.submit(RESET_SIGNAL);
                        }
                        catch (IllegalStateException illegalStateException) {}
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (this.timeoutJob != null && !this.timeoutJob.isDone()) {
                        this.timeoutJob.cancel(true);
                        this.timeoutJob = null;
                    }
                    try {
                        this.submit(RESET_SIGNAL);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    throw throwable;
                }
                if (this.timeoutJob != null && !this.timeoutJob.isDone()) {
                    this.timeoutJob.cancel(true);
                    this.timeoutJob = null;
                }
                try {
                    this.submit(RESET_SIGNAL);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        });
    }

    private int sliceAndOffer(@NotNull ByteBuffer combo, @NotNull byte[] leftover, int leftoverLen, @NotNull ByteBuffer readBuf, int read) {
        combo.clear();
        if (leftoverLen > 0) {
            combo.put(leftover, 0, leftoverLen);
        }
        combo.put(readBuf.array(), 0, read);
        combo.flip();
        int total = combo.remaining();
        int trimmed = total - total % this.frameSize;
        int fullPacketsBytes = trimmed - trimmed % this.packetBytes;
        int produced = 0;
        while (produced < fullPacketsBytes) {
            ByteBuffer chunk = ByteBuffer.allocate(this.packetBytes);
            combo.get(chunk.array(), 0, this.packetBytes);
            chunk.position(0);
            chunk.limit(this.packetBytes);
            this.offerFrame(chunk);
            produced += this.packetBytes;
        }
        int carry = total - produced;
        if (carry > 0) {
            combo.get(leftover, 0, carry);
        }
        return carry;
    }

    private void offerFrame(@NotNull ByteBuffer frame) {
        try {
            int res = this.offer(frame, 300L, TimeUnit.MILLISECONDS, this.onDropHandler());
            if (res < 0) {
                log.warn((Object)"Frame dropped for all subscribers.");
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @NotNull
    public CompletableFuture<AIAudioStream> getResult() {
        return this.result;
    }

    @NotNull
    private BiPredicate<Flow.Subscriber<? super ByteBuffer>, ? super ByteBuffer> onDropHandler() {
        return (subscriber, item) -> {
            log.warn((Object)("Dropping frame for subscriber: " + String.valueOf(subscriber)));
            return false;
        };
    }

    public void stop() {
        this.resume();
        this.running.set(false);
    }

    public boolean pause() {
        return this.paused.compareAndSet(false, true);
    }

    public boolean resume() {
        boolean changed = this.paused.compareAndSet(true, false);
        Thread t = this.readerThread;
        if (changed && t != null) {
            LockSupport.unpark(t);
        }
        return changed;
    }

    @Override
    public void close() {
        this.stop();
        this.executorService.shutdownNow();
        super.close();
    }
}

