/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.anthropic;

import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatCompletionChunk;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatCompletionRequest;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicChatCompletionResult;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicModelDTO;
import com.dbeaver.model.ai.engine.anthropic.dto.AnthropicModelsDTO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.AbstractHttpAIClient;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AnthropicClient
extends AbstractHttpAIClient {
    private static final Log log = Log.getLog(AnthropicClient.class);
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final String BASE_URL = "https://api.anthropic.com/v1/";
    private static final String DATA_EVENT = "data: ";
    private static final String DONE_EVENT = "event: message_stop";
    private static final String MODEL_DISCOVERY_URL = "https://api.anthropic.com/v1/models";
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    private static final Gson REQUEST_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    public static final String ANROPIC_VERSION = "2023-06-01";
    private final String token;

    public AnthropicClient(@NotNull String token) {
        this.token = token;
    }

    public List<AnthropicModelDTO> loadModels(@NotNull DBRProgressMonitor monitor, @NotNull String token) throws DBException {
        URI uri = AIHttpUtils.resolve((String)MODEL_DISCOVERY_URL, (String[])new String[0]);
        String responseBody = this.client.send(monitor, HttpRequest.newBuilder().header("Content-Type", "application/json").uri(uri).header("x-api-key", token).header("anthropic-version", ANROPIC_VERSION).timeout(TIMEOUT).build());
        AnthropicModelsDTO anthropicModelsDTO = (AnthropicModelsDTO)GSON.fromJson(responseBody, AnthropicModelsDTO.class);
        return anthropicModelsDTO.data();
    }

    public AnthropicChatCompletionResult createChatCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AnthropicChatCompletionRequest completionRequest) throws DBException {
        HttpRequest request = this.buildMessageRequest(completionRequest);
        return (AnthropicChatCompletionResult)GSON.fromJson(this.client.send(monitor, request), AnthropicChatCompletionResult.class);
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AnthropicChatCompletionRequest completionRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = this.buildMessageRequest(completionRequest);
        StringConsumer stringConsumer = new StringConsumer(listener);
        this.client.sendAsync(request, (Consumer)stringConsumer, arg_0 -> ((AIEngineResponseConsumer)listener).error(arg_0), () -> ((AIEngineResponseConsumer)listener).close());
    }

    @NotNull
    protected DBException mapHttpError(int statusCode, @NotNull String body) {
        log.debug((Object)("Anthropic request failed: " + statusCode + ", " + body));
        return new DBException("Anthropic request failed: " + AIHttpUtils.parseOpenAIStyleErrorMessage((String)body));
    }

    private HttpRequest buildMessageRequest(@NotNull AnthropicChatCompletionRequest completionRequest) throws DBException {
        return HttpRequest.newBuilder().uri(AIHttpUtils.resolve((String)BASE_URL, (String[])new String[]{"messages"})).headers(this.getHeaders()).POST(HttpRequest.BodyPublishers.ofString(this.serializeValue(completionRequest))).timeout(TIMEOUT).build();
    }

    private String[] getHeaders() {
        return new String[]{"Content-Type", "application/json", "x-api-key", this.token, "anthropic-version", ANROPIC_VERSION};
    }

    private String serializeValue(Object value) throws DBException {
        try {
            return REQUEST_GSON.toJson(value);
        }
        catch (Exception e) {
            throw new DBException("Error serializing value", (Throwable)e);
        }
    }

    private static class StringConsumer
    implements Consumer<String> {
        private final AIEngineResponseConsumer listener;
        StringBuilder inputJson = new StringBuilder();
        String currentToolCallName = null;

        public StringConsumer(AIEngineResponseConsumer listener) {
            this.listener = listener;
        }

        @Override
        public void accept(String event) {
            if (CommonUtils.isEmpty((String)event)) {
                return;
            }
            if (event.startsWith(AnthropicClient.DATA_EVENT)) {
                String data = event.substring(6).trim();
                if (AnthropicClient.DONE_EVENT.equals(data)) {
                    this.listener.close();
                } else {
                    try {
                        AnthropicChatCompletionChunk chunk = (AnthropicChatCompletionChunk)GSON.fromJson(data, AnthropicChatCompletionChunk.class);
                        if (chunk.type().equals("error")) {
                            this.listener.error((Throwable)new DBException("Error from Anthropic: \n\tType: %s\n\tMessage: %s".formatted(chunk.type(), chunk.error().message())));
                            return;
                        }
                        if (chunk.contentBlock() != null && "tool_use".equals(chunk.contentBlock().type())) {
                            this.currentToolCallName = chunk.contentBlock().name();
                            return;
                        }
                        if (this.currentToolCallName != null) {
                            if (chunk.type().equals("content_block_stop")) {
                                this.listener.nextChunk(new AIEngineResponseChunk(new AIFunctionCall(this.currentToolCallName, (Map)GSON.fromJson(this.inputJson == null ? "" : this.inputJson.toString(), Map.class))));
                                this.currentToolCallName = null;
                                this.inputJson = new StringBuilder();
                                return;
                            }
                            if (chunk.type().equals("content_block_delta")) {
                                this.inputJson.append(chunk.delta().partialJson());
                                return;
                            }
                        }
                        if (chunk.delta() == null || chunk.delta().text() == null || chunk.delta().text().isBlank()) {
                            return;
                        }
                        this.listener.nextChunk(new AIEngineResponseChunk(List.of(chunk.delta().text())));
                    }
                    catch (Exception e) {
                        this.listener.error((Throwable)e);
                    }
                }
            }
        }
    }
}

