/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;

public class AzureRequestFilter
implements OpenAIClient.HttpRequestFilter {
    private final String token;
    private final String version;

    public AzureRequestFilter(String token, String version) {
        this.token = token;
        this.version = version;
    }

    @NotNull
    public HttpRequest filter(@NotNull HttpRequest request, boolean setContentType) throws DBException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(request.uri()).method(request.method(), request.bodyPublisher().orElse(HttpRequest.BodyPublishers.noBody())).header("api-key", this.token);
        for (Map.Entry<String, List<String>> headerEntry : request.headers().map().entrySet()) {
            for (String value : headerEntry.getValue()) {
                builder.header(headerEntry.getKey(), value);
            }
        }
        if (setContentType) {
            builder.header("Content-Type", "application/json").header("Cache-Control", "no-cache");
        }
        return builder.build();
    }

    @NotNull
    private URI addVersionParam(URI originalUri) throws DBException {
        try {
            String originalQuery = originalUri.getQuery();
            String newQueryParam = "api-version=" + this.version;
            String newQuery = originalQuery == null || originalQuery.isEmpty() ? newQueryParam : originalQuery + "&" + newQueryParam;
            return new URI(originalUri.getScheme(), originalUri.getAuthority(), originalUri.getPath(), newQuery, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new DBException("Error filtering request", (Throwable)e);
        }
    }
}

