/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.gemini.dto;

import com.dbeaver.model.ai.engine.gemini.dto.GeminiContent;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiFunction;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiGenerationConfig;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiSafetySettings;
import com.dbeaver.model.ai.engine.gemini.dto.GeminiSystemInstruction;
import com.dbeaver.model.ai.engine.gemini.dto.ToolsConfig;
import java.util.List;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.utils.CommonUtils;

public record GeminiGenerateRequest(List<GeminiContent> contents, GeminiSystemInstruction systemInstruction, GeminiSafetySettings safetySettings, GeminiGenerationConfig generationConfig, ToolsConfig tools) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<GeminiContent> contents;
        private GeminiSystemInstruction systemInstruction;
        private GeminiSafetySettings safetySettings;
        private GeminiGenerationConfig generationConfig;
        private List<GeminiFunction> functions;

        public Builder contents(List<GeminiContent> contents) {
            this.contents = contents;
            return this;
        }

        public Builder systemInstruction(GeminiSystemInstruction systemInstruction) {
            this.systemInstruction = systemInstruction;
            return this;
        }

        public Builder safetySettings(GeminiSafetySettings safetySettings) {
            this.safetySettings = safetySettings;
            return this;
        }

        public Builder generationConfig(GeminiGenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        public GeminiGenerateRequest build() {
            return new GeminiGenerateRequest(this.contents, this.systemInstruction, this.safetySettings, this.generationConfig, !CommonUtils.isEmpty(this.functions) ? new ToolsConfig(this.functions) : null);
        }

        public Builder functions(List<AIFunctionDescriptor> functions) {
            this.functions = functions.stream().map(GeminiFunction::new).toList();
            return this;
        }
    }
}

