/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.vqb.model;

import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDContainer;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class VQBUtils {
    private static final Log log = Log.getLog(VQBUtils.class);

    public static Expression unwrapExpression(Expression expr) {
        return expr;
    }

    public static void collectNestedConditions(VQBQueryInfo queryInfo, List<Expression> nestedConditions, Expression parentExpr, Expression expr) {
        if ((expr = VQBUtils.unwrapExpression(expr)) instanceof BinaryExpression && expr.getClass() == parentExpr.getClass()) {
            VQBUtils.collectNestedConditions(queryInfo, nestedConditions, expr, ((BinaryExpression)expr).getLeftExpression());
            VQBUtils.collectNestedConditions(queryInfo, nestedConditions, expr, ((BinaryExpression)expr).getRightExpression());
        } else if (!queryInfo.isConditionExcluded(expr)) {
            nestedConditions.add(expr);
        }
    }

    public static boolean isCompoundExpression(Expression expr) {
        return expr instanceof AndExpression || expr instanceof OrExpression || expr instanceof ParenthesedExpressionList;
    }

    public static Table getTableFromEntity(ERDEntity erdEntity) {
        FromItem fromItem = (FromItem)erdEntity.getUserData();
        return fromItem instanceof Table ? (Table)fromItem : null;
    }

    public static String getFromItemName(FromItem fromItem) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            return table.getName();
        }
        return fromItem.toString();
    }

    @NotNull
    public static List<Join> getQueryJoins(PlainSelect plainSelect) {
        ArrayList joins = plainSelect.getJoins();
        if (joins == null) {
            joins = new ArrayList();
            plainSelect.setJoins(joins);
        }
        return joins;
    }

    public static void addJoinToList(List<Join> joins, Join join) {
        if (join.isSimple() && !joins.isEmpty()) {
            joins.add(0, join);
        } else {
            joins.add(join);
        }
    }

    public static boolean isEntityJoin(Join join, ERDEntity entity) {
        return join.getRightItem() instanceof Table && VQBUtils.equalTables((Table)join.getRightItem(), entity);
    }

    public static boolean equalTables(Table table, ERDEntity erdEntity) {
        if (table == null || erdEntity == null) {
            return table == null && erdEntity == null;
        }
        DBPDataSource dataSource = ((DBSEntity)erdEntity.getObject()).getDataSource();
        String tableName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)table.getName());
        if (table.getAlias() != null && !CommonUtils.isEmpty((String)erdEntity.getAlias())) {
            return CommonUtils.equalObjects((Object)tableName, (Object)erdEntity.getName()) && CommonUtils.equalObjects((Object)table.getAlias().getName(), (Object)erdEntity.getAlias());
        }
        DBSEntity entity = (DBSEntity)erdEntity.getObject();
        DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)entity);
        DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)entity);
        if (catalog != null && table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName()) && !CommonUtils.equalObjects((Object)catalog.getName(), (Object)DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)table.getDatabase().getDatabaseName()))) {
            return false;
        }
        if (schema != null && table.getSchemaName() != null && !CommonUtils.equalObjects((Object)schema.getName(), (Object)table.getSchemaName())) {
            return false;
        }
        String a1 = table.getAlias() == null ? null : table.getAlias().getName();
        String a2 = erdEntity.getAlias();
        return CommonUtils.equalObjects((Object)tableName, (Object)entity.getName()) && a1 == null && a2 == null || CommonUtils.equalObjects((Object)tableName, (Object)a2) || CommonUtils.equalObjects((Object)entity.getName(), (Object)a1);
    }

    public static boolean equalTables(Table t1, Table t2) {
        String a2;
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (t1.getAlias() != null && t2.getAlias() != null) {
            return CommonUtils.equalObjects((Object)t1.getAlias().getName(), (Object)t2.getAlias().getName());
        }
        if (!CommonUtils.equalObjects((Object)(t1.getDatabase() == null ? null : t1.getDatabase().getDatabaseName()), t2.getDatabase() == null ? null : t2.getDatabase().getDatabaseName())) {
            return false;
        }
        if (!CommonUtils.equalObjects((Object)t1.getSchemaName(), (Object)t2.getSchemaName())) {
            return false;
        }
        String a1 = t1.getAlias() == null ? null : t1.getAlias().getName();
        String string = a2 = t2.getAlias() == null ? null : t2.getAlias().getName();
        return CommonUtils.equalObjects((Object)t1.getName(), (Object)t2.getName()) || CommonUtils.equalObjects((Object)t1.getName(), (Object)a2) || CommonUtils.equalObjects((Object)t2.getName(), (Object)a1);
    }

    public static List<SelectItem<?>> getOrCreateSelectItems(PlainSelect plainSelect) {
        ArrayList selectItems = plainSelect.getSelectItems();
        if (selectItems == null) {
            selectItems = new ArrayList();
            plainSelect.setSelectItems(selectItems);
        }
        return selectItems;
    }

    public static void handleEntityChange(ERDContainer diagram, VQBQueryInfo queryInfo, ERDEntity entity, boolean remove, DBPPreferenceStore prefStore) {
        PlainSelect plainSelect = queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!remove) {
                List<SelectItem<?>> selectItems;
                boolean isMainTable;
                boolean bl = isMainTable = plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), entity);
                if (isMainTable && (selectItems = VQBUtils.getOrCreateSelectItems(plainSelect)).isEmpty()) {
                    selectItems.add(new SelectItem((Expression)new AllColumns()));
                }
                if (!isMainTable && CommonUtils.isEmpty((Collection)entity.getReferences())) {
                    List<Join> joins = VQBUtils.getQueryJoins(plainSelect);
                    Join simpleJoin = new Join();
                    simpleJoin.setSimple(true);
                    Table tableFromEntity = VQBUtils.getTableFromEntity(entity);
                    simpleJoin.setRightItem((FromItem)tableFromEntity);
                    int indexToInsertInJoinList = -1;
                    if (joins.size() > 1) {
                        int i = 0;
                        while (i <= joins.size() - 1) {
                            Join listJoin = joins.get(i);
                            Expression onExpression = VQBUtils.getJoinOnExpression(listJoin);
                            if (onExpression != null) {
                                Expression leftExpression;
                                Table leftTable = null;
                                if (onExpression instanceof EqualsTo && (leftExpression = ((EqualsTo)onExpression).getLeftExpression()) instanceof Column) {
                                    leftTable = ((Column)leftExpression).getTable();
                                }
                                if (leftTable != null && VQBUtils.equalTables(leftTable, tableFromEntity)) {
                                    indexToInsertInJoinList = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (indexToInsertInJoinList != -1) {
                        joins.add(indexToInsertInJoinList, simpleJoin);
                    } else {
                        VQBUtils.addJoinToList(joins, simpleJoin);
                    }
                    ERDEntity primaryEntity = null;
                    for (ERDEntity diagramEntity : diagram.getEntities()) {
                        if (!diagramEntity.isPrimary()) continue;
                        primaryEntity = diagramEntity;
                        break;
                    }
                    if (primaryEntity != null) {
                        ERDJoin erdJoin = new ERDJoin(primaryEntity, entity, true);
                        erdJoin.setUserData(simpleJoin);
                    }
                }
            } else {
                VQBUtils.removeTableReferences(diagram, plainSelect, entity, prefStore);
            }
        }
    }

    public static Expression getJoinOnExpression(Join join) {
        Collection onExpressions = join.getOnExpressions();
        return CommonUtils.isEmpty((Collection)onExpressions) ? null : (Expression)onExpressions.iterator().next();
    }

    public static void updateTableAlias(VQBQueryInfo queryInfo, final Table changingTable, final Alias alias) {
        Statement statement = queryInfo.getParsedQuery();
        if (statement instanceof Select) {
            Select select = (Select)statement;
            select.accept((SelectVisitor)new SelectVisitorAdapter<Object>(){

                public <S> Object visit(PlainSelect plainSelect, S context) {
                    if (plainSelect.getFromItem() != null) {
                        plainSelect.getFromItem().accept((FromItemVisitor)new FromItemVisitorAdapter<Object>(){

                            public <S> Object visit(Table table, S context) {
                                if (table != changingTable && VQBUtils.equalTables(table, changingTable)) {
                                    table.setAlias(alias);
                                }
                                return super.visit(table, context);
                            }
                        });
                    }
                    if (plainSelect.getJoins() != null) {
                        for (Join join : plainSelect.getJoins()) {
                            Expression onExpr = VQBUtils.getJoinOnExpression(join);
                            if (onExpr == null) continue;
                            VQBUtils.updateTableAlias(onExpr, changingTable, alias);
                        }
                    }
                    if (plainSelect.getSelectItems() != null) {
                        for (SelectItem item : plainSelect.getSelectItems()) {
                            VQBUtils.updateTableAlias(item.getExpression(), changingTable, alias);
                        }
                    }
                    if (plainSelect.getWhere() != null) {
                        VQBUtils.updateTableAlias(plainSelect.getWhere(), changingTable, alias);
                    }
                    if (plainSelect.getHaving() != null) {
                        VQBUtils.updateTableAlias(plainSelect.getHaving(), changingTable, alias);
                    }
                    if (plainSelect.getGroupBy() != null) {
                        ExpressionList expressionList = plainSelect.getGroupBy().getGroupByExpressionList();
                        for (Expression item : expressionList) {
                            VQBUtils.updateTableAlias(item, changingTable, alias);
                        }
                    }
                    if (plainSelect.getOrderByElements() != null) {
                        for (SelectItem item : plainSelect.getOrderByElements()) {
                            if (item.getExpression() == null) continue;
                            VQBUtils.updateTableAlias(item.getExpression(), changingTable, alias);
                        }
                    }
                    return super.visit(plainSelect, context);
                }
            }, (Object)changingTable);
        }
        changingTable.setAlias(alias);
    }

    public static void updateTableAlias(Expression expression, final Table changedTable, Alias alias) {
        expression.accept((ExpressionVisitor)new ExpressionVisitorAdapter<Object>(){

            public <S> Object visit(Column column, S context) {
                if (column.getTable() != changedTable && VQBUtils.equalTables(column.getTable(), changedTable)) {
                    column.setTable(changedTable);
                }
                if (changedTable.getAlias() != null && column.getTable() != null && changedTable.getAlias().getName().equals(column.getTable().getName())) {
                    column.setTable(changedTable);
                }
                return super.visit(column, context);
            }
        });
    }

    public static void removeTableReferences(ERDContainer diagram, PlainSelect plainSelect, ERDEntity entity, DBPPreferenceStore prefStore) {
        List orderByElements;
        Expression expr;
        List groupByRefs;
        ExpressionList expressionList;
        Iterator iter;
        List joins = plainSelect.getJoins();
        if (joins != null) {
            iter = joins.iterator();
            while (iter.hasNext()) {
                Join join = (Join)iter.next();
                if (VQBUtils.isEntityJoin(join, entity)) {
                    ERDJoin erdJoin = VQBUtils.findERDJoin((ERDDiagram)diagram, join);
                    if (erdJoin != null) {
                        erdJoin.getSourceEntity().removeAssociation((ERDAssociation)erdJoin, true);
                        erdJoin.getTargetEntity().removeReferenceAssociation((ERDAssociation)erdJoin, true);
                    }
                    iter.remove();
                    continue;
                }
                List<Expression> expressions = Collections.singletonList(VQBUtils.removeTableReferences(VQBUtils.getJoinOnExpression(join), entity, prefStore));
                if (expressions.get(0) == null) {
                    join.setOnExpressions(Collections.emptyList());
                    continue;
                }
                join.setOnExpressions((Collection)expressions);
            }
        }
        if (plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), entity)) {
            if (CommonUtils.isEmpty((Collection)joins)) {
                plainSelect.setFromItem(null);
            } else {
                Join firstJoin = (Join)joins.remove(0);
                plainSelect.setFromItem(firstJoin.getRightItem());
                for (ERDEntity e : diagram.getEntities()) {
                    if (e.getUserData() != firstJoin.getRightItem()) continue;
                    e.setPrimary(true);
                    e.firePropertyChange("NAME", null, (Object)e.getName());
                }
            }
        }
        if (plainSelect.getSelectItems() != null) {
            iter = plainSelect.getSelectItems().iterator();
            while (iter.hasNext()) {
                SelectItem item = (SelectItem)iter.next();
                Expression expression = item.getExpression();
                Expression res = VQBUtils.removeTableReferences(expression, entity, prefStore);
                if (res == null) {
                    iter.remove();
                    continue;
                }
                item.setExpression(res);
            }
            if (CommonUtils.isEmpty((Collection)plainSelect.getSelectItems()) && plainSelect.getFromItem() != null) {
                plainSelect.addSelectItems(new Expression[]{new AllColumns()});
            }
            if (plainSelect.getFromItem() == null && plainSelect.getSelectItems().size() == 1 && ((SelectItem)plainSelect.getSelectItems().get(0)).getExpression() instanceof AllColumns) {
                plainSelect.setSelectItems(null);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.setWhere(VQBUtils.removeTableReferences(plainSelect.getWhere(), entity, prefStore));
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.setHaving(VQBUtils.removeTableReferences(plainSelect.getHaving(), entity, prefStore));
        }
        if (plainSelect.getGroupBy() != null && (expressionList = plainSelect.getGroupBy().getGroupByExpressionList()) != null && (groupByRefs = expressionList.getExpressions()) != null) {
            int i = 0;
            while (i < groupByRefs.size()) {
                expr = VQBUtils.removeTableReferences((Expression)groupByRefs.get(i), entity, prefStore);
                if (expr == null) {
                    groupByRefs.remove(i);
                    continue;
                }
                groupByRefs.set(i, expr);
                ++i;
            }
        }
        if ((orderByElements = plainSelect.getOrderByElements()) != null) {
            int i = 0;
            while (i < orderByElements.size()) {
                OrderByElement obe = (OrderByElement)orderByElements.get(i);
                expr = VQBUtils.removeTableReferences(obe.getExpression(), entity, prefStore);
                if (expr == null) {
                    orderByElements.remove(i);
                    continue;
                }
                obe.setExpression(expr);
                ++i;
            }
        }
    }

    public static Expression removeTableReferences(Expression expr, ERDEntity entity, DBPPreferenceStore prefStore) {
        Column rightExpr;
        Expression expression;
        Column leftExpr;
        ComparisonOperator cmp;
        Expression expression2;
        if (expr instanceof ComparisonOperator && ((expression2 = (cmp = (ComparisonOperator)expr).getLeftExpression()) instanceof Column && VQBUtils.equalTables((leftExpr = (Column)expression2).getTable(), entity) || (expression = cmp.getRightExpression()) instanceof Column && VQBUtils.equalTables((rightExpr = (Column)expression).getTable(), entity))) {
            return null;
        }
        if (expr instanceof BinaryExpression) {
            Expression leftFiltered = VQBUtils.removeTableReferences(((BinaryExpression)expr).getLeftExpression(), entity, prefStore);
            Expression rightFiltered = VQBUtils.removeTableReferences(((BinaryExpression)expr).getRightExpression(), entity, prefStore);
            if (leftFiltered == null && rightFiltered == null) {
                return null;
            }
            if (leftFiltered == null) {
                return rightFiltered;
            }
            if (rightFiltered == null) {
                return leftFiltered;
            }
        }
        if (expr instanceof Column) {
            Column column = (Column)expr;
            boolean isAliasAlways = prefStore.getBoolean("vqb.add.aliases.always");
            if (VQBUtils.equalTables(column.getTable(), entity) || !isAliasAlways && column.getTable() == null && VQBUtils.entityHasColumn(entity, column)) {
                return null;
            }
        }
        return expr;
    }

    private static boolean entityHasColumn(ERDEntity entity, Column column) {
        List attributes = entity.getAttributes();
        String columnName = column.getColumnName();
        if (columnName != null) {
            for (ERDEntityAttribute attr : attributes) {
                if (!attr.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Join findEntityJoin(ERDDiagram diagram, PlainSelect plainSelect, ERDEntity rightEntity, ERDEntity leftEntity) {
        if (plainSelect.getJoins() == null) {
            return null;
        }
        for (Join join : plainSelect.getJoins()) {
            boolean matchesRightEntity;
            if (!(join.getRightItem() instanceof Table)) continue;
            boolean bl = matchesRightEntity = rightEntity != null && VQBUtils.equalTables((Table)join.getRightItem(), rightEntity);
            if (!matchesRightEntity && (leftEntity == null || !VQBUtils.equalTables((Table)join.getRightItem(), leftEntity))) continue;
            Expression onExpr = VQBUtils.getJoinOnExpression(join);
            if (onExpr == null) {
                return join;
            }
            if (!(matchesRightEntity ? VQBUtils.containsTableReferences(onExpr, leftEntity) : VQBUtils.containsTableReferences(onExpr, rightEntity))) continue;
            return join;
        }
        return null;
    }

    public static boolean containsTableReferences(Expression expr, ERDEntity entity) {
        Column rightExpr;
        Expression expression;
        Column leftExpr;
        ComparisonOperator cmp;
        Expression expression2;
        return expr instanceof ComparisonOperator ? (expression2 = (cmp = (ComparisonOperator)expr).getLeftExpression()) instanceof Column && VQBUtils.equalTables((leftExpr = (Column)expression2).getTable(), entity) || (expression = cmp.getRightExpression()) instanceof Column && VQBUtils.equalTables((rightExpr = (Column)expression).getTable(), entity) : expr instanceof BinaryExpression && (VQBUtils.containsTableReferences(((BinaryExpression)expr).getLeftExpression(), entity) || VQBUtils.containsTableReferences(((BinaryExpression)expr).getRightExpression(), entity));
    }

    public static ERDJoin findERDJoin(ERDDiagram diagram, Join join) {
        for (ERDEntity entity : diagram.getEntities()) {
            for (ERDAssociation a : CommonUtils.safeList((List)entity.getAssociations())) {
                if (a.getUserData() != join || !(a instanceof ERDJoin)) continue;
                return (ERDJoin)a;
            }
            for (ERDAssociation r : CommonUtils.safeList((List)entity.getReferences())) {
                if (r.getUserData() != join || !(r instanceof ERDJoin)) continue;
                return (ERDJoin)r;
            }
        }
        return null;
    }

    public static List<String> getAttributeNames(ERDDiagram diagram, boolean addStars) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (ERDEntity entity : diagram.getEntities()) {
            String entityAlias;
            String string = entityAlias = !CommonUtils.isEmpty((String)entity.getAlias()) ? entity.getAlias() : DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)entity.getObject()));
            if (addStars) {
                attrNames.add(entityAlias + ".*");
            }
            for (ERDEntityAttribute attr : entity.getAttributes()) {
                attrNames.add(entityAlias + "." + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)attr.getObject())));
            }
        }
        return attrNames;
    }

    @Nullable
    public static DBSEntityAttribute getAttributeByName(@NotNull DBPDataSource dataSource, @NotNull ERDDiagram diagram, @NotNull Column column) {
        String columnName = column.getColumnName();
        if (CommonUtils.isEmpty((String)columnName)) {
            return null;
        }
        String modifiedColumnName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)columnName);
        Table table = column.getTable();
        String tableName = null;
        if (table != null) {
            tableName = table.getName();
        }
        for (ERDEntity entity : CommonUtils.safeCollection((Collection)diagram.getEntities())) {
            if (!CommonUtils.isEmpty((String)tableName) && !tableName.equals(entity.getName()) && !tableName.equals(entity.getAlias())) continue;
            for (ERDEntityAttribute attr : CommonUtils.safeCollection((Collection)entity.getAttributes())) {
                if (!modifiedColumnName.equals(attr.getName())) continue;
                return (DBSEntityAttribute)attr.getObject();
            }
        }
        return null;
    }

    public static Select createEmptySelectStatement() {
        return new PlainSelect();
    }

    public static void replaceCompoundWithSingle(PlainSelect plainSelect, final BinaryExpression compound, final Expression replaceWith) {
        if (plainSelect.getWhere() == compound) {
            plainSelect.setWhere(replaceWith);
        } else {
            plainSelect.getWhere().accept((ExpressionVisitor)new ExpressionVisitorAdapter<Object>(){

                protected Object visitBinaryExpression(BinaryExpression value, Object context) {
                    if (value.getRightExpression() == compound) {
                        value.setRightExpression(replaceWith);
                    } else if (value.getLeftExpression() == compound) {
                        value.setLeftExpression(replaceWith);
                    } else {
                        return super.visitBinaryExpression(value, context);
                    }
                    return null;
                }
            });
        }
    }

    public static Expression makeColumnExpression(ERDEntity entity, ERDEntityAttribute attribute) {
        Column column = new Column(DBUtils.getQuotedIdentifier((DBPNamedObject)attribute));
        Table table = new Table(DBUtils.getQuotedIdentifier((DBPNamedObject)entity));
        if (!CommonUtils.isEmpty((String)entity.getAlias())) {
            table.setAlias(new Alias(entity.getAlias()));
        }
        if (((DBSEntity)entity.getObject()).getParentObject() instanceof DBSSchema) {
            table.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)((DBSEntity)entity.getObject()).getParentObject()));
        }
        column.setTable(table);
        return column;
    }

    public static String generateEntityAlias(ERDDiagram diagram, List<ERDEntity> otherEntities, DBSEntity entity, SQLSyntaxManager syntaxManager) {
        String entityAlias = SQLUtils.generateEntityAlias((DBSEntity)entity, s -> VQBUtils.aliasExist(diagram, otherEntities, s));
        DBPIdentifierCase keywordCase = syntaxManager.getKeywordCase();
        return keywordCase.transform(entityAlias);
    }

    public static boolean aliasExist(ERDDiagram diagram, List<ERDEntity> otherEntities, String alias) {
        for (ERDEntity entity : diagram.getEntities()) {
            if (!alias.equalsIgnoreCase(entity.getAlias()) && !alias.equalsIgnoreCase(entity.getName())) continue;
            return true;
        }
        for (ERDEntity entity : otherEntities) {
            if (!alias.equalsIgnoreCase(entity.getAlias()) && !alias.equalsIgnoreCase(entity.getName())) continue;
            return true;
        }
        return false;
    }

    public static void removeExpressionFromGrouping(@NotNull PlainSelect plainSelect, @NotNull SelectItem<?> selectExpressionItem, @NotNull GroupByElement groupBy) {
        Expression expression = selectExpressionItem.getExpression();
        List<Object> newGroupingList = new ArrayList();
        List selectItems = plainSelect.getSelectItems();
        boolean tableWithAlis = true;
        List groupByExpressions = null;
        ExpressionList expressionList = groupBy.getGroupByExpressionList();
        if (expressionList != null) {
            groupByExpressions = expressionList.getExpressions();
            if (expression instanceof Column && ((Column)expression).getTable() == null) {
                Column column = (Column)expression;
                tableWithAlis = false;
                for (Expression expr2 : groupByExpressions) {
                    String selectExprColumnName = column.getColumnName();
                    String columnName = VQBUtils.getColumnNameFromExpression(expr2);
                    if (columnName == null || columnName.equals(selectExprColumnName)) continue;
                    newGroupingList.add(expr2);
                }
            }
        }
        if (expression instanceof Function) {
            Function function = (Function)expression;
            expression = (Expression)function.getParameters().get(0);
        }
        Expression finalExpression = expression;
        if (tableWithAlis && !CommonUtils.isEmpty((Collection)groupByExpressions)) {
            newGroupingList = groupByExpressions.stream().filter(expr -> !finalExpression.toString().equals(expr.toString())).collect(Collectors.toList());
        }
        if (!CommonUtils.isEmpty(newGroupingList)) {
            VQBUtils.addDefaultAggregateFunction(selectExpressionItem);
            groupBy.setGroupByExpressions(new ExpressionList(newGroupingList));
        } else {
            plainSelect.setGroupByElement(null);
            List<SelectItem<?>> newSelectItems = VQBUtils.replaceAllFunctionsInPlainSelect(selectItems);
            plainSelect.setSelectItems(newSelectItems);
        }
    }

    public static void addDefaultAggregateFunction(SelectItem selectExpressionItem) {
        Expression expression = selectExpressionItem.getExpression();
        Function function = new Function();
        function.setName("COUNT");
        ExpressionList exprList = new ExpressionList(new Expression[0]);
        exprList.setExpressions(Collections.singletonList(expression));
        function.setParameters(exprList);
        selectExpressionItem.setExpression((Expression)function);
    }

    private static List<SelectItem<?>> replaceAllFunctionsInPlainSelect(List<SelectItem<?>> selectItems) {
        ArrayList newSelectItemsList = new ArrayList();
        for (SelectItem<?> sItem : selectItems) {
            Expression selectExpression = sItem.getExpression();
            if (selectExpression instanceof Function) {
                Function selectFunction = (Function)selectExpression;
                if (selectFunction.isAllColumns()) continue;
                Expression functionExpression = (Expression)selectFunction.getParameters().get(0);
                SelectItem newSelectExpressionItem = new SelectItem(functionExpression);
                newSelectItemsList.add(newSelectExpressionItem);
                continue;
            }
            newSelectItemsList.add(sItem);
        }
        return newSelectItemsList;
    }

    public static boolean isPartOf(Expression element, Expression expression) {
        if (element == expression) {
            return true;
        }
        if (expression instanceof BinaryExpression) {
            return VQBUtils.isPartOf(element, ((BinaryExpression)expression).getLeftExpression()) || VQBUtils.isPartOf(element, ((BinaryExpression)expression).getRightExpression());
        }
        return false;
    }

    @Nullable
    public static String getColumnNameFromExpression(@NotNull Expression expression) {
        Optional<Expression> first;
        List expressions;
        ExpressionList parameters;
        if (expression instanceof Column) {
            return ((Column)expression).getColumnName();
        }
        if (expression instanceof Function && (parameters = ((Function)expression).getParameters()) != null && !CommonUtils.isEmpty((Collection)(expressions = parameters.getExpressions())) && (first = expressions.stream().filter(e -> e instanceof Column).findFirst()).isPresent()) {
            return ((Column)first.get()).getColumnName();
        }
        return null;
    }

    public static void deleteJoin(@NotNull ERDDiagram diagram, @NotNull ERDAssociation erdJoin, @NotNull PlainSelect plainSelect) {
        Join join = (Join)erdJoin.getUserData();
        plainSelect.getJoins().remove(join);
        ERDEntity targetEntity = (ERDEntity)erdJoin.getTargetEntity();
        ERDEntity sourceEntity = (ERDEntity)erdJoin.getSourceEntity();
        sourceEntity.removeAssociation(erdJoin, true);
        targetEntity.removeReferenceAssociation(erdJoin, true);
        if (targetEntity.getUserData().equals(join.getRightItem()) && targetEntity.getReferences().size() == 0) {
            for (ERDAssociation association : targetEntity.getAssociations()) {
                VQBUtils.deleteJoin(diagram, association, plainSelect);
            }
        }
        if (sourceEntity.getUserData().equals(join.getRightItem()) && sourceEntity.getAssociations().size() == 0) {
            for (ERDAssociation association : sourceEntity.getReferences()) {
                VQBUtils.deleteJoin(diagram, association, plainSelect);
            }
        }
    }

    @NotNull
    public static Expression makeAndExpression(@NotNull List<Expression> expressions) {
        Expression result = expressions.get(0);
        int i = 1;
        while (i < expressions.size()) {
            result = new AndExpression(result, expressions.get(i));
            ++i;
        }
        return result;
    }

    @NotNull
    public static Expression removeConditionFromExpression(@NotNull Expression rootExpression, @NotNull Expression condition) {
        if (rootExpression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)rootExpression;
            if (be.getLeftExpression() == condition) {
                return be.getRightExpression();
            }
            if (be.getRightExpression() == condition) {
                return be.getLeftExpression();
            }
            be.setLeftExpression(VQBUtils.removeConditionFromExpression(be.getLeftExpression(), condition));
            be.setRightExpression(VQBUtils.removeConditionFromExpression(be.getRightExpression(), condition));
        }
        return rootExpression;
    }

    public static Expression updateConditionInExpression(Expression onExpression, Expression curExpression, Expression newExpression) {
        if (onExpression == curExpression) {
            return newExpression;
        }
        Expression exp = onExpression;
        while (exp != null) {
            if (exp instanceof AndExpression || exp instanceof OrExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)exp;
                if (binaryExpression.getLeftExpression() == curExpression) {
                    binaryExpression.setLeftExpression(newExpression);
                    return onExpression;
                }
                if (binaryExpression.getRightExpression() == curExpression) {
                    binaryExpression.setRightExpression(newExpression);
                    return onExpression;
                }
                exp = binaryExpression.getLeftExpression();
                continue;
            }
            return onExpression;
        }
        return onExpression;
    }
}

