/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBView;
import com.dbeaver.model.tableau.TBVirtualConnection;
import com.dbeaver.model.tableau.TBWorkbook;
import com.dbeaver.model.tableau.rest.api.DataSourceType;
import com.dbeaver.model.tableau.rest.api.PaginationType;
import com.dbeaver.model.tableau.rest.api.ProjectType;
import com.dbeaver.model.tableau.rest.api.SiteType;
import com.dbeaver.model.tableau.rest.api.TsResponse;
import com.dbeaver.model.tableau.rest.api.ViewType;
import com.dbeaver.model.tableau.rest.api.VirtualConnectionType;
import com.dbeaver.model.tableau.rest.api.WorkbookType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class TBSite
implements TBObject {
    private static final Log log = Log.getLog(TBSite.class);
    private static final String DEFAULT_SITE_NAME = "default";
    private final TBSession session;
    private final SiteType siteType;
    private List<TBDataSource> dataSources;
    private List<TBVirtualConnection> virtualConnections;
    private List<TBWorkbook> workbooks;
    private List<TBProject> projects;
    private List<TBView> views;

    public TBSite(TBSession session, SiteType siteType) {
        this.session = session;
        this.siteType = siteType;
    }

    public TBSession getSession() {
        return this.session;
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.siteType.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return CommonUtils.isEmpty((String)this.siteType.getContentUrl()) ? DEFAULT_SITE_NAME : this.siteType.getContentUrl();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(order=10, viewable=true)
    @Nullable
    public String getState() {
        return this.siteType.getState();
    }

    @Override
    public boolean needsDetails() {
        return false;
    }

    public List<TBDataSource> getDataSources(DBRProgressMonitor monitor) throws DBException {
        if (this.dataSources == null) {
            ArrayList<TBDataSource> tmpDataSources = new ArrayList<TBDataSource>();
            int pageNumber = 1;
            while (true) {
                TsResponse tsResponse = this.session.executeRequest(monitor, this.makeSiteEndpoint("datasources") + "?pageSize=1000&pageNumber=" + pageNumber);
                List<DataSourceType> dsResult = tsResponse.getDatasources().getDatasource();
                tmpDataSources.addAll(dsResult.stream().map(p -> new TBDataSource(this, (DataSourceType)p, this.getProject(monitor, p.getProject()))).toList());
                PaginationType pagination = tsResponse.getPagination();
                if (pagination == null || pagination.getPageNumber().intValue() * pagination.getPageSize().intValue() >= pagination.getTotalAvailable().intValue()) break;
                ++pageNumber;
            }
            this.dataSources = tmpDataSources;
        }
        return this.dataSources;
    }

    public void refreshObject() {
        this.dataSources = null;
        this.virtualConnections = null;
        this.workbooks = null;
        this.projects = null;
    }

    public TBDataSource getDataSource(DBRProgressMonitor monitor, String dsId) throws DBException {
        return this.getDataSources(monitor).stream().filter(ds -> ds.getId().equals(dsId)).findFirst().orElse(null);
    }

    public List<TBVirtualConnection> getVirtualConnections(DBRProgressMonitor monitor) throws DBException {
        if (this.virtualConnections == null) {
            this.virtualConnections = this.session.executeRequest(monitor, this.makeSiteEndpoint("virtualConnections")).getVirtualConnections().getVirtualConnection().stream().map(p -> new TBVirtualConnection(this, (VirtualConnectionType)p, this.getProject(monitor, p.getProject()))).collect(Collectors.toList());
        }
        return this.virtualConnections;
    }

    public TBVirtualConnection getVirtualConnection(DBRProgressMonitor monitor, String dsId) throws DBException {
        return this.getVirtualConnections(monitor).stream().filter(ds -> ds.getId().equals(dsId)).findFirst().orElse(null);
    }

    public List<TBView> getViews(DBRProgressMonitor monitor, TBWorkbook workbook) throws DBException {
        if (this.views == null) {
            this.views = this.session.executeRequest(monitor, this.makeSiteEndpoint("views")).getViews().getView().stream().map(p -> new TBView(this, (ViewType)p, this.getProject(monitor, p.getProject()))).collect(Collectors.toList());
        }
        if (workbook != null) {
            return this.views.stream().filter(v -> v.getViewType().getWorkbook().getId().equals(workbook.getId())).toList();
        }
        return this.views;
    }

    public List<TBWorkbook> getWorkbooks(DBRProgressMonitor monitor) throws DBException {
        if (this.workbooks == null) {
            this.workbooks = this.session.executeRequest(monitor, this.makeSiteEndpoint("workbooks")).getWorkbooks().getWorkbook().stream().map(p -> new TBWorkbook(this, (WorkbookType)p, this.getProject(monitor, p.getProject()))).collect(Collectors.toList());
        }
        return this.workbooks;
    }

    public TBWorkbook getWorkbook(DBRProgressMonitor monitor, String id) throws DBException {
        for (TBWorkbook wb : this.getWorkbooks(monitor)) {
            if (!wb.getId().equals(id)) continue;
            return wb;
        }
        return null;
    }

    public List<TBProject> getRootProjects(DBRProgressMonitor monitor) throws DBException {
        ArrayList<TBProject> roots = new ArrayList<TBProject>();
        for (TBProject p : this.getProjects(monitor)) {
            if (p.getParentProject() != null) continue;
            roots.add(p);
        }
        return roots;
    }

    public List<TBProject> getProjects(DBRProgressMonitor monitor) throws DBException {
        if (this.projects == null) {
            List<ProjectType> allProjects = this.session.executeRequest(monitor, this.makeSiteEndpoint("projects")).getProjects().getProject();
            this.projects = new ArrayList<TBProject>();
            HashMap<String, TBProject> projectMap = new HashMap<String, TBProject>();
            for (ProjectType pt : allProjects) {
                TBProject parentProject = null;
                if (!CommonUtils.isEmpty((String)pt.getParentProjectId())) {
                    parentProject = (TBProject)projectMap.get(pt.getParentProjectId());
                }
                TBProject project = new TBProject(this, parentProject, pt);
                this.projects.add(project);
                projectMap.put(project.getId(), project);
            }
        }
        return this.projects;
    }

    TBProject getProject(DBRProgressMonitor monitor, ProjectType projectType) {
        if (projectType == null) {
            return null;
        }
        try {
            return this.getProjects(monitor).stream().filter(p -> p.getId().equals(projectType.getId())).findFirst().orElse(null);
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    List<TBProject> getProjects() {
        return this.projects;
    }

    String makeSiteEndpoint(String endpoint) {
        return "sites/" + this.getId() + "/" + endpoint;
    }

    TsResponse executeRequest(DBRProgressMonitor monitor, String endpoint) throws DBException {
        return this.session.executeRequest(monitor, this.makeSiteEndpoint(endpoint));
    }
}

