/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBDataSource;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.auth.TBAuthConfiguration;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.navigator.DBNTableauRootNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.model.tableau.tds.TDSModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TBUtils {
    private static final Log log = Log.getLog(TBUtils.class);

    @Nullable
    public static DBNTableauRootNode getTableauProjectNode(DBNModel model) {
        DBNProject projectNode = model.getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        if (projectNode != null) {
            return (DBNTableauRootNode)projectNode.getExtraNode(DBNTableauRootNode.class);
        }
        return null;
    }

    public static boolean isConnectionLinked(DBPDataSourceContainer dataSourceContainer, TDSConnection tableauConnection) {
        String dsConList = (String)dataSourceContainer.getExtension("tableau.connections");
        if (!CommonUtils.isEmpty((String)dsConList)) {
            return dsConList.contains(tableauConnection.getName());
        }
        return false;
    }

    public static boolean isTableauLinked(DBPDataSourceContainer dataSourceContainer) {
        String dsConList = (String)dataSourceContainer.getExtension("tableau.connections");
        return !CommonUtils.isEmpty((String)dsConList);
    }

    public static void linkDataSourceWithConnection(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, TDSConnection tableauConnection) throws DBException {
        DataSourceAssociation dsa = new DataSourceAssociation(monitor, tableauConnection.getDataSource().getSession(), dataSourceContainer);
        dsa.addConnection(tableauConnection);
        dataSourceContainer.setExtension("tableau.connections", (Object)dsa.makeReferenceString());
        dataSourceContainer.getRegistry().flushConfig();
    }

    public static void unlinkDataSourceWithConnection(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, TDSConnection tableauConnection) throws DBException {
        DataSourceAssociation dsa = new DataSourceAssociation(monitor, tableauConnection.getDataSource().getSession(), dataSourceContainer);
        dsa.removeConnection(tableauConnection);
        String refString = dsa.makeReferenceString();
        if (CommonUtils.isEmpty((String)refString)) {
            dataSourceContainer.setExtension("tableau.connections", null);
        } else {
            dataSourceContainer.setExtension("tableau.connections", (Object)refString);
        }
        dataSourceContainer.getRegistry().flushConfig();
    }

    public static List<DBPDataSourceContainer> getAssociatedDataSources(DBPDataSourceRegistry registry, TDSConnection tdsConnection) {
        return registry.getDataSources().stream().filter(ds -> TBUtils.isConnectionLinked(ds, tdsConnection)).collect(Collectors.toList());
    }

    public static class DataSourceAssociation {
        private List<TDSConnection> connectionList;

        public DataSourceAssociation(DBRProgressMonitor monitor, TBSession tbSession, DBPDataSourceContainer ds) throws DBException {
            String dsConList = (String)ds.getExtension("tableau.connections");
            if (!CommonUtils.isEmpty((String)dsConList)) {
                this.connectionList = new ArrayList<TDSConnection>();
                String[] stringArray = dsConList.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dsRef = stringArray[n2];
                    String[] tbConRef = dsRef.split("/");
                    if (tbConRef.length != 4) {
                        log.debug((Object)("Invalid tableau connection reference: '" + dsRef + "'"));
                    } else {
                        TBAuthProfile profile = TBAuthConfiguration.getConfiguration().getProfileById(tbConRef[0]);
                        if (profile == null) {
                            log.debug((Object)("Tableau profile '" + tbConRef[0] + "' not found"));
                        } else {
                            TBSite site = tbSession.getSite(monitor, tbConRef[1]);
                            if (site == null) {
                                log.debug((Object)("Tableau site '" + tbConRef[1] + "' not found"));
                            } else {
                                TBDataSource tbDS = site.getDataSource(monitor, tbConRef[2]);
                                if (tbDS == null) {
                                    log.debug((Object)("Tableau data source '" + tbConRef[2] + "' not found"));
                                } else {
                                    TDSModel tdsModel = tbDS.getModel(monitor);
                                    TDSConnection tdsConnection = tdsModel.getConnectionByName(tbConRef[3]);
                                    if (tdsConnection == null) {
                                        log.debug((Object)("Tableau connection '" + tbConRef[3] + "' not found"));
                                    } else {
                                        this.connectionList.add(tdsConnection);
                                    }
                                }
                            }
                        }
                    }
                    ++n2;
                }
            } else {
                this.connectionList = null;
            }
        }

        public List<TDSConnection> getConnectionList() {
            return this.connectionList == null ? Collections.emptyList() : this.connectionList;
        }

        public void addConnection(TDSConnection connection) {
            if (this.connectionList == null) {
                this.connectionList = new ArrayList<TDSConnection>();
            }
            this.connectionList.add(connection);
        }

        public void removeConnection(TDSConnection connection) {
            this.connectionList.remove(connection);
        }

        public String makeReferenceString() {
            StringBuilder ref = new StringBuilder();
            if (this.connectionList != null) {
                for (TDSConnection con : this.connectionList) {
                    if (ref.length() > 0) {
                        ref.append(",");
                    }
                    TBDataSource dataSource = con.getDataSource();
                    TBSite site = dataSource.getSite();
                    TBAuthProfile profile = dataSource.getSession().getAuthProfile();
                    ref.append(profile.getId()).append("/").append(site.getId()).append("/").append(dataSource.getId()).append("/").append(con.getName());
                }
            }
            return ref.toString();
        }
    }
}

