/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.dashboard;

import com.dbeaver.model.tableau.TBView;
import com.dbeaver.model.tableau.TBWorkbook;
import com.dbeaver.model.tableau.dashboard.TableauDashboardFolderSite;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.dashboard.DBDashboardContext;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class TableauDashboardFolderWorkbook
implements DBDashboardFolder {
    private final TableauDashboardFolderSite site;
    private final TBWorkbook workbook;

    public TableauDashboardFolderWorkbook(TableauDashboardFolderSite site, TBWorkbook workbook) {
        this.site = site;
        this.workbook = workbook;
    }

    @NotNull
    public DBDashboardFolder getParent() {
        return this.site;
    }

    @NotNull
    public String getId() {
        return this.workbook.getId();
    }

    @NotNull
    public String getName() {
        return this.workbook.getName();
    }

    @Nullable
    public String getDescription() {
        return this.workbook.getDescription();
    }

    @Nullable
    public DBPImage getIcon() {
        return DBIcon.TREE_FOLDER_VIEW;
    }

    public boolean containsDashboards() {
        return true;
    }

    @NotNull
    public List<DBDashboardFolder> loadSubFolders(@NotNull DBRProgressMonitor monitor, @NotNull DBDashboardContext context) throws DBException {
        return List.of();
    }

    @NotNull
    public List<DashboardItemConfiguration> loadDashboards(@NotNull DBRProgressMonitor monitor, @NotNull DBDashboardContext context) throws DBException {
        ArrayList<DashboardItemConfiguration> dashboards = new ArrayList<DashboardItemConfiguration>();
        List<TBView> views = this.workbook.getSite().getViews(monitor, this.workbook);
        for (TBView view : views) {
            DashboardItemConfiguration viewDashboard = new DashboardItemConfiguration(this.site.getParent().getProvider(), (DBDashboardFolder)this, "tableau." + view.getId(), view.getName(), view.getDescription(), "Tableau", false);
            viewDashboard.setDataType(DBDashboardDataType.provided);
            viewDashboard.setRenderer("browser");
            viewDashboard.setDashboardURL(view.getViewURL(true));
            viewDashboard.setDashboardExternalURL(view.getViewURL(false));
            dashboards.add(viewDashboard);
        }
        return dashboards;
    }
}

