/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNTableauProjectNode
extends DBNTableauAbstractNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauProjectNode.class);
    private final TBProject project;
    private DBNTableauProjectNode[] children;

    DBNTableauProjectNode(DBNNode parentNode, TBProject project) {
        super(parentNode);
        this.project = project;
    }

    @NotNull
    public String getNodeType() {
        return "Tableau project";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.project.getName();
    }

    @Nullable
    public String getNodeDescription() {
        return this.project.getDescription();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_INFO;
    }

    protected boolean allowsChildren() {
        return this.project.hasSubProjects();
    }

    @Nullable
    public DBNTableauProjectNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = (DBNTableauProjectNode[])this.project.getSubProjects().stream().map(p -> new DBNTableauProjectNode(this, (TBProject)p)).toArray(DBNTableauProjectNode[]::new);
        }
        return this.children;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.children = null;
        return super.refreshNode(monitor, source);
    }

    public Object getNodeObject() {
        return this.project;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }
}

