/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.upd.impl;

import com.dbeaver.jdbc.upd.protocol.UPDResultSet;
import com.dbeaver.model.upd.impl.UPDObjectManager;
import com.dbeaver.model.upd.impl.UPDServerConnection;
import com.dbeaver.model.upd.impl.UPDServerObject;
import com.dbeaver.model.upd.impl.UPDServerStatement;
import com.dbeaver.model.upd.impl.UPDServerUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;

public class UPDServerResultSet
extends UPDServerObject {
    private static final Log log = Log.getLog(UPDServerResultSet.class);
    @NotNull
    private final UPDServerConnection connection;
    @NotNull
    private UPDServerStatement statement;
    boolean readMetaData;
    private ResultSet resultSet;

    public UPDServerResultSet(@NotNull UPDObjectManager objectManager, @NotNull UPDServerConnection connection, @NotNull UPDServerStatement statement, boolean readMetaData, @NotNull ResultSet resultSet) {
        super(objectManager);
        this.connection = connection;
        this.statement = statement;
        this.readMetaData = readMetaData;
        this.resultSet = resultSet;
    }

    @NotNull
    public UPDServerConnection getConnection() {
        return this.connection;
    }

    @Nullable
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public UPDResultSet createProtocolObject() throws SQLException {
        return UPDServerUtils.createFrom(this.getObjectId(), this.readMetaData, this.resultSet);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }
}

