/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.auth;

import com.dbeaver.model.auth.SMAuthUtils;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionWithAuth;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.utils.CommonUtils;

public class SMContextVariableResolver
implements IVariableResolver {
    private SMSessionWithAuth session;
    private DataSourceVariableResolver dsResolver;

    public SMContextVariableResolver(DBRProgressMonitor monitor, DBSSecretObject secretObject) throws DBException {
        if (secretObject instanceof DBPDataSourceContainer) {
            DBPDataSourceContainer ds = (DBPDataSourceContainer)secretObject;
            this.dsResolver = new DataSourceVariableResolver(ds, ds.getActualConnectionConfiguration());
            SMSession sMSession = SMAuthUtils.getPrimarySession(monitor, ds.getProject());
            if (sMSession instanceof SMSessionWithAuth) {
                SMSessionWithAuth sr;
                this.session = sr = (SMSessionWithAuth)sMSession;
            }
        }
    }

    private static String getChildProperty(String property, String prefix) {
        if (property.startsWith(prefix + ".")) {
            return property.substring(prefix.length() + 1);
        }
        return null;
    }

    @Nullable
    public String get(@NotNull String name) {
        String dsProperty = SMContextVariableResolver.getChildProperty(name, "datasource");
        if (dsProperty != null) {
            String value = this.dsResolver.get(dsProperty);
            if (value != null) {
                return value;
            }
            return name;
        }
        String authPropName = SMContextVariableResolver.getChildProperty(name, "auth");
        if (authPropName != null) {
            if (this.session != null) {
                for (SMAuthInfo authInfo : this.session.getAuthInfos()) {
                    for (Object authData : authInfo.getAuthData().values()) {
                        Object authValue;
                        Map adm;
                        Map<String, Object> authAttributes;
                        if (!(authData instanceof Map) || (authAttributes = SMAuthUtils.getCustomAuthAttributes(adm = (Map)authData)) == null || (authValue = authAttributes.get(authPropName)) == null) continue;
                        return CommonUtils.toString((Object)authValue);
                    }
                }
            }
            return name;
        }
        return name;
    }
}

