/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.data.hints;

import com.dbeaver.model.data.hints.ValueHintForeignKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public class ForeignKeyCellHintProvider
implements DBDCellHintProvider {
    private static final Log log = Log.getLog(ForeignKeyCellHintProvider.class);

    @Nullable
    public DBDValueHint[] getCellHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull DBDValueRow row, @Nullable Object value, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        if (DBUtils.isNullValue((Object)value)) {
            return null;
        }
        List referrers = attribute.getReferrers();
        if (!CommonUtils.isEmpty((Collection)referrers)) {
            ArrayList<ValueHintForeignKey> refHints = new ArrayList<ValueHintForeignKey>();
            for (DBSEntityReferrer referrer : referrers) {
                Object hintText;
                DBSEntityConstraint refConstr;
                DBSEntityAssociation ea;
                if (!(referrer instanceof DBSEntityAssociation) || this.isTableReferenceExists(ea = (DBSEntityAssociation)referrer, refHints) || (refConstr = ea.getReferencedConstraint()) == null) continue;
                ReferenceCache referenceCache = this.getReferenceCache(model.getHintContext());
                AttributeDictCache dictCache = referenceCache.dictsCache.get(attribute);
                if (dictCache == null) continue;
                if (CommonUtils.isBitSet((int)options, (int)32)) {
                    refHints.add(new ValueHintForeignKey(attribute, ea));
                    continue;
                }
                Map<DBDValueRow, Object> valueStringMap = dictCache.entityValues.get(ea.getAssociatedEntity());
                if (valueStringMap == null || (hintText = valueStringMap.get(row)) == null) continue;
                refHints.add(new ValueHintForeignKey(hintText, attribute, row, ea));
            }
            return refHints.toArray(new DBDValueHint[0]);
        }
        return null;
    }

    public int getAttributeHintSize(@NotNull DBDValueHintContext context, @NotNull DBDAttributeBinding attribute) {
        List referrers = attribute.getReferrers();
        if (!CommonUtils.isEmpty((Collection)referrers)) {
            ReferenceCache referenceCache = this.getReferenceCache(context);
            AttributeDictCache dictCache = referenceCache.dictsCache.get(attribute);
            if (dictCache != null) {
                return 24;
            }
        }
        return 0;
    }

    public void cacheRequiredData(@NotNull DBRProgressMonitor monitor, @NotNull DBDValueHintContext context, @NotNull Collection<DBDAttributeBinding> attributes, @NotNull Collection<? extends DBDValueRow> rows, boolean cleanupCache) throws DBException {
        if (cleanupCache) {
            this.cleanupReferenceCache(context);
        }
        if (rows.isEmpty()) {
            return;
        }
        LinkedHashMap<DBSEntityReferrer, Set<RefKeyValue>> dictsToCache = new LinkedHashMap<DBSEntityReferrer, Set<RefKeyValue>>();
        ReferenceCache referenceCache = this.getReferenceCache(context);
        for (DBDAttributeBinding attr : attributes) {
            if (CommonUtils.isEmpty((Collection)attr.getReferrers())) continue;
            AttributeDictCache dictCache = referenceCache.getDictCache(attr);
            for (DBSEntityReferrer er : attr.getReferrers()) {
                DBSEntityAssociation ea;
                DBSEntity entity;
                if (!(er instanceof DBSEntityAssociation) || !((entity = (ea = (DBSEntityAssociation)er).getAssociatedEntity()) instanceof DBSDictionary)) continue;
                Map<DBDValueRow, Object> valueCache = dictCache.getValueCache(entity);
                Set keyToCache = dictsToCache.computeIfAbsent(er, entity1 -> new LinkedHashSet());
                this.readDictCacheForRows(monitor, valueCache, attributes, er, rows, keyToCache, !cleanupCache);
            }
        }
        if (!dictsToCache.isEmpty()) {
            this.readCache(monitor, rows, attributes, referenceCache, dictsToCache);
        }
    }

    private void readDictCacheForRows(@NotNull DBRProgressMonitor monitor, @NotNull Map<DBDValueRow, Object> valueCache, @NotNull Collection<DBDAttributeBinding> attributes, @NotNull DBSEntityReferrer entityReferrer, @NotNull Collection<? extends DBDValueRow> rows, @NotNull Set<RefKeyValue> keyToCache, boolean forceRefresh) throws DBException {
        ArrayList<DBDAttributeBinding> referrerAttrs = new ArrayList<DBDAttributeBinding>(2);
        block0: for (DBSEntityAttributeRef dBSEntityAttributeRef : CommonUtils.safeCollection((Collection)entityReferrer.getAttributeReferences(monitor))) {
            for (DBDAttributeBinding binding : attributes) {
                if (dBSEntityAttributeRef.getAttribute() == null || binding.getEntityAttribute() != dBSEntityAttributeRef.getAttribute()) continue;
                referrerAttrs.add(binding);
                continue block0;
            }
        }
        if (!referrerAttrs.isEmpty()) {
            for (DBDValueRow dBDValueRow : rows) {
                RefKeyValue keyValues = new RefKeyValue(new Object[referrerAttrs.size()]);
                int i = 0;
                while (i < referrerAttrs.size()) {
                    DBDAttributeBinding attr = (DBDAttributeBinding)referrerAttrs.get(i);
                    keyValues.values[i] = dBDValueRow.getValues()[attr.getOrdinalPosition()];
                    ++i;
                }
                if (!forceRefresh && valueCache.containsKey(dBDValueRow)) continue;
                keyToCache.add(keyValues);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readCache(DBRProgressMonitor monitor, Collection<? extends DBDValueRow> rows, Collection<DBDAttributeBinding> attributes, ReferenceCache referenceCache, Map<DBSEntityReferrer, Set<RefKeyValue>> dictsToCache) throws DBException {
        for (Map.Entry<DBSEntityReferrer, Set<RefKeyValue>> entry : dictsToCache.entrySet()) {
            void var20_21;
            void var20_23;
            boolean skipDictRead;
            DBSEntityAssociation assoc;
            DBSEntity dBSEntity;
            DBSEntityReferrer referrer = entry.getKey();
            if (!(referrer instanceof DBSEntityAssociation) || !((dBSEntity = (assoc = (DBSEntityAssociation)referrer).getAssociatedEntity()) instanceof DBSDictionary)) continue;
            DBSDictionary dictionary = (DBSDictionary)dBSEntity;
            List<Object[]> keyValues = entry.getValue().stream().map(kv -> kv.values).toList();
            ArrayList<DBSEntityAttribute> refKeyColumns = new ArrayList<DBSEntityAttribute>();
            List attrRefs = CommonUtils.safeList((List)referrer.getAttributeReferences(monitor));
            for (DBSEntityAttributeRef ar : attrRefs) {
                if (ar.getAttribute() == null) {
                    log.debug((Object)"Null Reference attribute");
                    continue;
                }
                DBSEntityAttribute refAttr = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)assoc, (DBSEntityAttribute)ar.getAttribute(), (boolean)false);
                if (refAttr == null) {
                    log.debug((Object)("Reference attribute '" + String.valueOf(ar.getAttribute()) + "' not found in entity '" + String.valueOf(assoc.getAssociatedEntity()) + "'"));
                    continue;
                }
                refKeyColumns.add(refAttr);
            }
            if (refKeyColumns.isEmpty()) continue;
            String descColumns = DBVUtils.getDictionaryDescriptionColumns((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)refKeyColumns.get(0)));
            boolean bl = skipDictRead = descColumns == null || descColumns.equals(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)refKeyColumns.get(0))));
            if (skipDictRead) {
                return;
            }
            List dictionaryValues = dictionary.getDictionaryValues(monitor, refKeyColumns, keyValues, null, false, false, true);
            HashMap<RefKeyValue, List> rowMap = new HashMap<RefKeyValue, List>();
            DBDAttributeBinding[] attrBindings = new DBDAttributeBinding[attrRefs.size()];
            boolean bl2 = false;
            while (var20_23 < attrRefs.size()) {
                DBSEntityAttributeRef keyColumn = (DBSEntityAttributeRef)attrRefs.get((int)var20_23);
                attrBindings[var20_23] = attributes.stream().filter(a -> a.getEntityAttribute() == keyColumn.getAttribute()).findAny().orElse(null);
                if (attrBindings[var20_23] == null) {
                    throw new DBException("Cannot find attribute '" + String.valueOf(keyColumn.getAttribute()) + "' binding");
                }
                ++var20_23;
            }
            for (DBDValueRow dBDValueRow : rows) {
                Object[] rowKeyValues = new Object[attrBindings.length];
                int i2 = 0;
                while (i2 < attrBindings.length) {
                    DBDAttributeBinding dBDAttributeBinding = attrBindings[i2];
                    Object attrValue = dBDValueRow.getValues()[dBDAttributeBinding.getOrdinalPosition()];
                    if (attrValue instanceof Date) {
                        attrValue = dBDAttributeBinding.getValueHandler().getValueDisplayString((DBSTypedObject)dBDAttributeBinding, attrValue, DBDDisplayFormat.UI);
                    }
                    rowKeyValues[i2] = attrValue;
                    ++i2;
                }
                rowMap.computeIfAbsent(new RefKeyValue(rowKeyValues), refKeyValue -> new ArrayList()).add(dBDValueRow);
            }
            boolean bl3 = false;
            while (var20_21 < attrRefs.size()) {
                DBDAttributeBinding binding = attrBindings[var20_21];
                if (binding != null) {
                    ArrayList<? extends DBDValueRow> missedRows = new ArrayList<DBDValueRow>(rows);
                    Map<DBDValueRow, Object> valueCache = referenceCache.getDictCache(binding).getValueCache(assoc.getAssociatedEntity());
                    for (DBDLabelValuePair dBDLabelValuePair : dictionaryValues) {
                        Object[] objectArray;
                        Object dictKeyValue = dBDLabelValuePair.getValue();
                        if (dictKeyValue instanceof Object[]) {
                            Object[] arr = (Object[])dictKeyValue;
                            objectArray = arr;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = dictKeyValue;
                        }
                        RefKeyValue refKeyValue2 = new RefKeyValue(objectArray);
                        List cachedRows = (List)rowMap.get(refKeyValue2);
                        if (cachedRows == null) continue;
                        for (DBDValueRow cachedRow : cachedRows) {
                            valueCache.put(cachedRow, dBDLabelValuePair.getLabel());
                            missedRows.remove(cachedRow);
                        }
                    }
                    if (!missedRows.isEmpty()) {
                        for (DBDValueRow dBDValueRow : missedRows) {
                            valueCache.put(dBDValueRow, ValueHintForeignKey.DICT_KEY_MISSING);
                        }
                    }
                }
                ++var20_21;
            }
        }
    }

    private void cleanupReferenceCache(DBDValueHintContext context) {
        context.setHintContextAttribute("dictCache", null);
    }

    private ReferenceCache getReferenceCache(DBDValueHintContext context) {
        ReferenceCache cache = (ReferenceCache)context.getHintContextAttribute("dictCache");
        if (cache == null) {
            cache = new ReferenceCache();
            context.setHintContextAttribute("dictCache", (Object)cache);
        }
        return cache;
    }

    private boolean isTableReferenceExists(DBSEntityAssociation assoc, List<ValueHintForeignKey> hints) {
        for (ValueHintForeignKey hr : hints) {
            if (assoc.getAssociatedEntity() != hr.getAssociation().getAssociatedEntity()) continue;
            return true;
        }
        return false;
    }

    static class AttributeDictCache {
        Map<DBSEntity, Map<DBDValueRow, Object>> entityValues = new IdentityHashMap<DBSEntity, Map<DBDValueRow, Object>>();

        AttributeDictCache() {
        }

        public Map<DBDValueRow, Object> getValueCache(DBSEntity entity) {
            return this.entityValues.computeIfAbsent(entity, b -> new HashMap());
        }
    }

    record RefKeyValue(Object[] values) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof RefKeyValue) {
                RefKeyValue rkv = (RefKeyValue)obj;
                Object[] values2 = rkv.values;
                int length = this.values.length;
                if (values2.length != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (!CommonUtils.toString((Object)this.values[i]).equals(CommonUtils.toString((Object)values2[i]))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = 1;
            Object[] objectArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                result = 31 * result + (element == null ? 0 : element.toString().hashCode());
                ++n2;
            }
            return result;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    static class ReferenceCache {
        Map<DBDAttributeBinding, AttributeDictCache> dictsCache = new IdentityHashMap<DBDAttributeBinding, AttributeDictCache>();

        ReferenceCache() {
        }

        public AttributeDictCache getDictCache(DBDAttributeBinding attr) {
            return this.dictsCache.computeIfAbsent(attr, b -> new AttributeDictCache());
        }
    }
}

