/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource;

import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceParseResults;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializerModern;

public class DataSourceSerializerModernPRO
extends DataSourceSerializerModern<DataSourceDescriptorPRO> {
    private static final Log log = Log.getLog(DataSourceSerializerModernPRO.class);
    public static final String ATTR_EXTERNAL_CONFIG = "externalParametersConfig";

    public DataSourceSerializerModernPRO(@NotNull DataSourceRegistry<DataSourceDescriptorPRO> registry) {
        super(registry);
    }

    protected void serializeDataSource(@NotNull DataSourceConfigurationManager configurationManager, @NotNull JsonWriter json, @NotNull DataSourceDescriptorPRO dataSource, @NotNull Map<String, DBPExternalConfiguration> externalConfigurations) throws IOException {
        super.serializeDataSource(configurationManager, json, (DataSourceDescriptor)dataSource, externalConfigurations);
        if (dataSource.getExternalParametersConfig() != null) {
            json.name(ATTR_EXTERNAL_CONFIG);
            json.jsonValue(CONFIG_GSON.toJson((Object)dataSource.getExternalParametersConfig()));
        }
        if (dataSource.isDetachedProcessEnabled()) {
            JSONUtils.field((JsonWriter)json, (String)"dpi-enabled", (boolean)true);
        }
    }

    protected void deserializeDataSource(@NotNull DataSourceParseResults parseResults, @NotNull DataSourceDescriptorPRO dataSource, @NotNull Map<String, Object> conObject) {
        super.deserializeDataSource(parseResults, (DataSourceDescriptor)dataSource, conObject);
        dataSource.setDetachedProcessEnabled(JSONUtils.getBoolean(conObject, (String)"dpi-enabled"));
    }

    protected void deserializeAdditionalProperties(@NotNull DataSourceDescriptorPRO dataSource, @NotNull Map<String, Object> conObject) {
        super.deserializeAdditionalProperties((DataSourceDescriptor)dataSource, conObject);
        Map externalParametersConfig = JSONUtils.getObject(conObject, (String)ATTR_EXTERNAL_CONFIG);
        if (!externalParametersConfig.isEmpty()) {
            try {
                DBPDatasourceExternalParameters config = (DBPDatasourceExternalParameters)JSONUtils.deserializeObject((Map)externalParametersConfig, DBPDatasourceExternalParameters.class);
                dataSource.setExternalParametersConfig(config);
            }
            catch (DBCException e) {
                log.error((Object)"Failed to deserialize external parameters config", (Throwable)e);
            }
        } else {
            dataSource.setExternalParametersConfig(null);
        }
    }
}

