/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.handlers;

import com.dbeaver.model.data.DBContentByteBuffer;
import com.dbeaver.model.document.handlers.DocumentBaseValueHandler;
import java.nio.ByteBuffer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DocumentContentValueHandler
extends DocumentBaseValueHandler {
    public static final DocumentContentValueHandler INSTANCE = new DocumentContentValueHandler();

    @NotNull
    public Class<DBDContent> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBDContent.class;
    }

    public DBContentByteBuffer getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new DBContentByteBuffer(session.getExecutionContext());
        }
        if (object instanceof DBContentByteBuffer) {
            DBContentByteBuffer src = (DBContentByteBuffer)((Object)object);
            return copy ? new DBContentByteBuffer(session.getExecutionContext(), src.getData()) : src;
        }
        if (object instanceof ByteBuffer) {
            return new DBContentByteBuffer(session.getExecutionContext(), (ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return new DBContentByteBuffer(session.getExecutionContext(), ByteBuffer.wrap((byte[])object));
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDContent) {
            String result = ((DBDContent)value).getDisplayString(format);
            if (result == null) {
                return super.getValueDisplayString(column, null, format);
            }
            return result;
        }
        return super.getValueDisplayString(column, value, format);
    }
}

