/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net.k8s;

import com.dbeaver.model.net.AbstractCommandLineTunnel;
import com.dbeaver.model.net.k8s.KubeCtrlExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class K8STunnelImpl
extends AbstractCommandLineTunnel {
    private static final Log log = Log.getLog(K8STunnelImpl.class);
    public static final int MAX_FORWARD_ATTEMPT_COUNT = 50;

    @Override
    protected Process createTunnelProcess(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration connectionInfo, int localPort) throws IOException, DBException {
        monitor.subTask("Initiate port forwarding");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("port-forward");
        args.add(configuration.getStringProperty("resource"));
        String remotePort = configuration.getStringProperty("remotePort");
        if (CommonUtils.isEmpty((String)remotePort)) {
            remotePort = K8STunnelImpl.getDefaultRemotePort(configuration);
        }
        args.add(localPort + ":" + remotePort);
        Process forwardPortProccess = KubeCtrlExecutor.executeCommandAndWait(monitor, configuration, args.toArray(new String[0]));
        int attemptCount = 0;
        while (forwardPortProccess.isAlive() && attemptCount < 50) {
            monitor.subTask("Waiting for tunnel establish");
            ++attemptCount;
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (Socket testSocket = new Socket();){
                    InetSocketAddress addr = new InetSocketAddress("127.0.0.1", localPort);
                    testSocket.connect(addr);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                RuntimeUtils.pause((int)100);
            }
        }
        if (attemptCount >= 50) {
            this.closeTunnel(monitor);
            throw new DBException("Error establishing port forwarding. Max attempt count (50) exceeded.");
        }
        monitor.subTask("Complete configuration");
        if (!forwardPortProccess.isAlive()) {
            try {
                RuntimeUtils.getProcessResults((Process)forwardPortProccess);
            }
            catch (InterruptedException interruptedException) {}
        }
        return forwardPortProccess;
    }

    @Override
    public boolean matchesParameters(@NotNull String host, int port) {
        if (host.equals(this.getConfiguration().getStringProperty("host"))) {
            int sshPort = this.getConfiguration().getIntProperty("port");
            return sshPort == port;
        }
        return false;
    }
}

