/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.qm.ai;

import com.dbeaver.model.qm.ai.QMAIChatMessage;
import com.dbeaver.model.qm.ai.QMAIChatStorage;
import com.dbeaver.model.qm.ai.QMAIContext;
import com.dbeaver.model.qm.ai.QMAIContextObject;
import com.dbeaver.model.qm.ai.QMAIConversationHistory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public class QMAIChatStorageInMemory
implements QMAIChatStorage {
    private final Map<String, Map<String, QMAIConversationHistory>> conversations = new ConcurrentHashMap<String, Map<String, QMAIConversationHistory>>();

    @Override
    @NotNull
    public List<QMAIConversationHistory> findConversations(@NotNull String sessionId) throws DBException {
        return this.conversations.getOrDefault(sessionId, Map.of()).values().stream().sorted((o1, o2) -> {
            if (o1.getMessages().isEmpty() && o2.getMessages().isEmpty()) {
                return 0;
            }
            if (o1.getMessages().isEmpty()) {
                return 1;
            }
            if (o2.getMessages().isEmpty()) {
                return -1;
            }
            return o1.getMessages().getLast().timestamp().compareTo(o2.getMessages().getLast().timestamp());
        }).toList();
    }

    @Override
    public void saveConversation(@NotNull String sessionId, @NotNull QMAIConversationHistory chat) throws DBException {
        this.conversations.computeIfAbsent(sessionId, k -> new ConcurrentHashMap()).put(chat.getId(), chat);
    }

    @Override
    public void appendMessages(@NotNull String conversationId, @NotNull List<QMAIChatMessage> messages) throws DBException {
        for (Map<String, QMAIConversationHistory> sessionConversations : this.conversations.values()) {
            QMAIConversationHistory chat = sessionConversations.get(conversationId);
            if (chat == null) continue;
            ArrayList<QMAIChatMessage> qmaiChatMessages = new ArrayList<QMAIChatMessage>(chat.getMessages());
            qmaiChatMessages.addAll(messages);
            chat.setMessages(qmaiChatMessages);
            return;
        }
        throw new DBException("Conversation not found: " + conversationId);
    }

    @Override
    public void deleteMessage(@NotNull String conversationId, int messageId) throws DBException {
        for (Map<String, QMAIConversationHistory> sessionConversations : this.conversations.values()) {
            QMAIConversationHistory chat = sessionConversations.get(conversationId);
            if (chat == null) continue;
            List<QMAIChatMessage> messages = chat.getMessages();
            messages.removeIf(message -> message.id() >= messageId);
            chat.setMessages(messages);
            return;
        }
        throw new DBException("Conversation not found: " + conversationId);
    }

    @Override
    public void extendContext(@NotNull String conversationId, @NotNull Set<QMAIContextObject> extra) throws DBException {
        for (Map<String, QMAIConversationHistory> sessionConversations : this.conversations.values()) {
            QMAIConversationHistory chat = sessionConversations.get(conversationId);
            if (chat == null) continue;
            QMAIContext context = chat.getContext();
            HashSet<QMAIContextObject> currentObjects = new HashSet<QMAIContextObject>(context.getObjects());
            currentObjects.addAll(extra);
            chat.setContext(new QMAIContext(context.getContextJson(), currentObjects));
            return;
        }
        throw new DBException("Conversation not found: " + conversationId);
    }

    @Override
    public void deleteConversation(@NotNull String conversationId) throws DBException {
        for (Map<String, QMAIConversationHistory> sessionConversations : this.conversations.values()) {
            if (sessionConversations.remove(conversationId) == null) continue;
            return;
        }
        throw new DBException("Conversation not found: " + conversationId);
    }

    @Override
    public void renameConversation(@NotNull String conversationId, @NotNull String newName) throws DBException {
        for (Map<String, QMAIConversationHistory> sessionConversations : this.conversations.values()) {
            QMAIConversationHistory chat = sessionConversations.get(conversationId);
            if (chat == null) continue;
            chat.setCaption(newName);
            return;
        }
        throw new DBException("Conversation not found: " + conversationId);
    }
}

