/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security.truststore.keystore;

import com.dbeaver.model.security.truststore.keystore.KeyStoreDescriptor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class KeyStoreRegistry {
    public static final String EXTENSION_ID = "com.dbeaver.keyStore";
    private static final String KEY_STORE_TAG = "keyStore";
    private final Map<String, KeyStoreDescriptor> keyStores = new LinkedHashMap<String, KeyStoreDescriptor>();
    private static KeyStoreRegistry instance;

    private KeyStoreRegistry() {
    }

    public static synchronized KeyStoreRegistry getInstance() {
        if (instance == null) {
            instance = new KeyStoreRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (KEY_STORE_TAG.equals(ext.getName())) {
                KeyStoreDescriptor descriptor = new KeyStoreDescriptor(ext);
                this.keyStores.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    public List<KeyStoreDescriptor> getSupportedKeyStores() {
        if (RuntimeUtils.isWindows()) {
            return this.keyStores.values().stream().filter(KeyStoreDescriptor::isWindows).toList();
        }
        if (RuntimeUtils.isMacOS()) {
            return this.keyStores.values().stream().filter(KeyStoreDescriptor::isMacOs).toList();
        }
        if (RuntimeUtils.isLinux()) {
            return this.keyStores.values().stream().filter(KeyStoreDescriptor::isUnix).toList();
        }
        return List.of();
    }

    @Nullable
    public KeyStoreDescriptor getKeyStoreById(String id) {
        return this.keyStores.get(id);
    }
}

