/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sm.permissions;

import com.dbeaver.model.sm.permissions.SMGlobalPermissionDescriptor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyGroupDescriptor;

public class SMGlobalPermissionsRegistry {
    private static final String EXTENSION_ID = "com.dbeaver.sm.permission";
    private static final String PERMISSION_TAG = "permission";
    private static SMGlobalPermissionsRegistry instance = null;
    private final Map<String, PropertyGroupDescriptor<SMGlobalPermissionDescriptor>> permissions = new LinkedHashMap<String, PropertyGroupDescriptor<SMGlobalPermissionDescriptor>>();

    private SMGlobalPermissionsRegistry() {
    }

    public static synchronized SMGlobalPermissionsRegistry getInstance() {
        if (instance == null) {
            instance = new SMGlobalPermissionsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("propertyGroup".equals(ext.getName())) {
                this.parsePermissionsGroup(ext, null);
            }
            ++n2;
        }
    }

    private void parsePermissionsGroup(IConfigurationElement ext, @Nullable PropertyGroupDescriptor<SMGlobalPermissionDescriptor> parentGroup) {
        PropertyGroupDescriptor<SMGlobalPermissionDescriptor> permissionsGroup = new PropertyGroupDescriptor<SMGlobalPermissionDescriptor>(ext);
        if (this.permissions.containsKey(permissionsGroup.getId())) {
            permissionsGroup = this.permissions.get(permissionsGroup.getId());
        } else {
            this.permissions.put(permissionsGroup.getId(), permissionsGroup);
        }
        if (parentGroup != null) {
            permissionsGroup.setParentGroup(parentGroup);
            parentGroup.addSubGroup(permissionsGroup);
        }
        IConfigurationElement[] iConfigurationElementArray = ext.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement childExt = iConfigurationElementArray[n2];
            if ("propertyGroup".equals(childExt.getName())) {
                this.parsePermissionsGroup(childExt, permissionsGroup);
            } else if (PERMISSION_TAG.equals(childExt.getName())) {
                SMGlobalPermissionDescriptor productSettingDescriptor = new SMGlobalPermissionDescriptor(permissionsGroup.getFullId(), childExt);
                permissionsGroup.addProperty((PropertyDescriptor)productSettingDescriptor);
            }
            ++n2;
        }
    }

    @Nullable
    public SMGlobalPermissionDescriptor getPermissionDescriptor(@NotNull String id) {
        return this.getPermissionsMap().get(id);
    }

    @NotNull
    public Collection<SMGlobalPermissionDescriptor> getPermissions() {
        return this.permissions.values().stream().flatMap(group -> group.getSettings().stream()).toList();
    }

    @NotNull
    public Map<String, SMGlobalPermissionDescriptor> getPermissionsMap() {
        return this.getPermissions().stream().collect(Collectors.toMap(PropertyDescriptor::getId, Function.identity()));
    }

    @NotNull
    public Collection<PropertyGroupDescriptor<SMGlobalPermissionDescriptor>> getPermissionsGroups() {
        return this.permissions.values();
    }
}

