/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.timeseries;

import com.dbeaver.model.timeseries.TSDataProvider;
import com.dbeaver.model.timeseries.TSMeasurement;
import com.dbeaver.model.timeseries.TSPoint;
import com.dbeaver.model.timeseries.TSProjection;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class SimpleTimeSeriesDataProvider
implements TSDataProvider {
    private DBDAttributeBinding timeAttr;
    private final List<MeasurementAttribute> measures = new ArrayList<MeasurementAttribute>();
    private final List<ProjectionAttribute> projections = new ArrayList<ProjectionAttribute>();

    @Override
    public void initData(DBDAttributeBinding[] metaData, Object[][] data) throws DBException {
        if (metaData.length == 0) {
            return;
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = metaData;
        int n = metaData.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            switch (attr.getDataKind()) {
                case DATETIME: {
                    this.timeAttr = attr;
                    break;
                }
                case NUMERIC: {
                    if (!this.measures.isEmpty()) break;
                    this.measures.add(new MeasurementAttribute(attr));
                    break;
                }
                case STRING: {
                    if (!this.projections.isEmpty()) break;
                    LinkedHashSet<Object> uniqueValues = new LinkedHashSet<Object>();
                    int index = attr.getOrdinalPosition();
                    Object[][] objectArray = data;
                    int n3 = data.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object[] objectArray2 = objectArray[n4];
                        uniqueValues.add(objectArray2[index]);
                        ++n4;
                    }
                    for (Object e : uniqueValues) {
                        this.projections.add(new ProjectionAttribute(attr, e));
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    @Override
    public String getSeriesName() {
        DBSEntityAttribute entityAttribute;
        if (this.timeAttr != null && (entityAttribute = this.timeAttr.getEntityAttribute()) != null) {
            return entityAttribute.getParentObject().getName();
        }
        return null;
    }

    @NotNull
    public List<MeasurementAttribute> getMeasurements() {
        return this.measures;
    }

    @Nullable
    public List<ProjectionAttribute> getProjections(Object[][] data) {
        return this.projections;
    }

    @Override
    @NotNull
    public List<TSPoint> getPoints(@NotNull TSMeasurement measurement, @Nullable TSProjection projection, Object[][] rowData) throws DBException {
        ArrayList<TSPoint> result = new ArrayList<TSPoint>(rowData.length);
        int timeIndex = this.timeAttr.getOrdinalPosition();
        int mIndex = ((MeasurementAttribute)measurement).attr.getOrdinalPosition();
        int pIndex = projection == null ? -1 : ((ProjectionAttribute)projection).attr.getOrdinalPosition();
        Object[][] objectArray = rowData;
        int n = rowData.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Object value;
                Object timeValue;
                Object[] row;
                block5: {
                    row = objectArray[n2];
                    timeValue = row[timeIndex];
                    if (pIndex < 0) break block5;
                    Object pValue = row[pIndex];
                    if (!CommonUtils.equalObjects((Object)projection.getValue(), (Object)CommonUtils.toString((Object)pValue))) break block6;
                }
                if (timeValue instanceof Date && (value = row[mIndex]) instanceof Number) {
                    result.add(new TSPoint((Date)timeValue, (Number)value));
                }
            }
            ++n2;
        }
        return result;
    }

    private static class MeasurementAttribute
    extends TSMeasurement {
        private final DBDAttributeBinding attr;

        public MeasurementAttribute(DBDAttributeBinding attr) {
            super(attr.getName());
            this.attr = attr;
        }

        @Override
        public String getDescription() {
            return this.attr.getDescription();
        }
    }

    private static class ProjectionAttribute
    extends TSProjection {
        private final DBDAttributeBinding attr;

        public ProjectionAttribute(DBDAttributeBinding attr, Object value) {
            super(attr.getName(), CommonUtils.toString((Object)value));
            this.attr = attr;
        }

        @Override
        public String getDescription() {
            return this.attr.getDescription();
        }
    }
}

