/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSSimpleCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelAWSSimple
extends AuthModelAWSAbstract {
    public static final String ID = "iam_simple";

    @Override
    @NotNull
    public AuthModelAWSCredentials createCredentials() {
        return new AuthModelAWSSimpleCredentials();
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (dataSource.getContainer().getDriver().getId().contains("athena")) {
            return AWSIAMUtils.tryExecuteRecover(monitor, credentials, () -> this.initAthenaAuthentication(monitor, dataSource, credentials, configuration, connProperties));
        }
        return credentials;
    }

    @Deprecated
    private Object initAthenaAuthentication(DBRProgressMonitor monitor, DBPDataSource dataSource, AuthModelAWSCredentials credentials, DBPConnectionConfiguration configuration, Properties connProperties) throws DBException {
        String regionName = configuration.getServerName();
        if (regionName == null) {
            regionName = configuration.getProviderProperty("AwsRegion");
        }
        if (regionName == null) {
            throw new DBException("AWS region not specified");
        }
        credentials.setRegion(regionName);
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        StringBuilder cpParams = new StringBuilder();
        if (!CommonUtils.isEmpty((String)awsCredentials.accessKeyId())) {
            cpParams.append(awsCredentials.accessKeyId()).append(",").append(awsCredentials.secretAccessKey());
        }
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)awsCredentials;
            cpParams.append(",").append(sessionCredentials.sessionToken());
        }
        connProperties.put("AwsCredentialsProviderClass", "com.dbeaver.db.athena.AthenaCredentialsProvider");
        connProperties.put("AwsCredentialsProviderArguments", cpParams.toString());
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    @Override
    public boolean supportsDatabaseUser() {
        return false;
    }
}

