/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.gcp;

import com.dbeaver.net.auth.gcp.AuthModelGCP;
import com.dbeaver.net.auth.gcp.AuthModelGCPSimpleCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelGCPFireStore
extends AuthModelGCP {
    public static final String ID = "gcp_cloud_iam_firestore";
    public static final String PROP_CONFIG_FILE = "credentialsFile";
    public static final String PROP_CONFIG_DATA = "credentials";
    public static final String PROP_PROJECT_ID = "projectId";

    @Override
    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelGCPSimpleCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (credentials != null && credentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
            if (CommonUtils.isNotEmpty((String)credentials.getServiceAccountConfigPath())) {
                connProperties.put(PROP_CONFIG_FILE, credentials.getServiceAccountConfigPath());
            }
            if (CommonUtils.isNotEmpty((String)credentials.getServiceAccountConfig())) {
                connProperties.put(PROP_CONFIG_DATA, credentials.getServiceAccountConfig());
            }
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
    }
}

