/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat;

import com.dbeaver.model.ai.audio.AIAssistantAudio;
import com.dbeaver.model.ai.audio.AIAudioRecorder;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.model.ai.audio.processing.AudioDurationMonitor;
import com.dbeaver.model.ai.audio.processing.AudioSink;
import com.dbeaver.model.ai.audio.processing.InMemoryAudioSink;
import com.dbeaver.model.ai.audio.processing.SilenceFilter;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sound.sampled.AudioFormat;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AIChatSpeechToTextService {
    private static final Log log = Log.getLog(AIChatSpeechToTextService.class);
    private static final CompletableFuture<AITranscriptResult> EMPTY = CompletableFuture.completedFuture(new AITranscriptResult("", new AITranscriptResult.Usage(Duration.ZERO)));
    private final AIAudioRecorder recorder;
    private final AIAssistantAudio aiAssistant;
    private final ExecutorService executor;
    private final AudioFormat format;

    public AIChatSpeechToTextService(int maxDurationSeconds, @NotNull AudioFormat format, @NotNull AIAssistantAudio aiAssistant, @Nullable Runnable longSilenceAction, @Nullable Runnable longAudioAction, @NotNull Collection<Flow.Subscriber<ByteBuffer>> subscribers) {
        this.format = format;
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
        this.recorder = this.buildRecorder(maxDurationSeconds, longSilenceAction, longAudioAction, subscribers);
        this.aiAssistant = aiAssistant;
    }

    @NotNull
    public CompletableFuture<AITranscriptResult> transcribe() {
        return this.recorder.getResult().thenComposeAsync(as -> {
            if (as.lengthSeconds() < 1.0) {
                return EMPTY;
            }
            try {
                return CompletableFuture.completedFuture(this.aiAssistant.createSpeechTranscription(as));
            }
            catch (DBException e) {
                return CompletableFuture.failedFuture(e);
            }
        }, (Executor)this.executor);
    }

    @NotNull
    public AITranscriptResult transcribeBlocking() throws DBException {
        try {
            return this.transcribe().get(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new DBException("Transcription timed out", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DBException("Transcription interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DBException) {
                DBException dbe = (DBException)cause;
                throw dbe;
            }
            throw new DBException("Transcription failed", cause != null ? cause : e);
        }
    }

    public void start() {
        this.recorder.start();
    }

    public void stop() {
        this.recorder.stop();
    }

    public void pause() {
        this.recorder.pause();
    }

    public void resume() {
        this.recorder.resume();
    }

    public void close() {
        this.recorder.close();
        this.executor.close();
    }

    @NotNull
    private AIAudioRecorder buildRecorder(int maxDurationSeconds, @Nullable Runnable longSilenceAction, @Nullable Runnable longAudioAction, @NotNull Collection<Flow.Subscriber<ByteBuffer>> subscribers) {
        SilenceFilter silenceFilter = this.buildSilenceFilter(longSilenceAction);
        InMemoryAudioSink sink = new InMemoryAudioSink(this.format);
        AudioDurationMonitor monitor = this.buildDurationMonitor(maxDurationSeconds, longAudioAction);
        silenceFilter.subscribe((Flow.Subscriber)sink);
        AIAudioRecorder rec = new AIAudioRecorder(this.format, (AudioSink)sink, (Executor)this.executor);
        rec.subscribe((Flow.Subscriber)silenceFilter);
        rec.subscribe((Flow.Subscriber)monitor);
        for (Flow.Subscriber<ByteBuffer> sub : subscribers) {
            rec.subscribe(sub);
        }
        return rec;
    }

    @NotNull
    private AudioDurationMonitor buildDurationMonitor(int maxDurationSeconds, @Nullable Runnable longAudioAction) {
        return new AudioDurationMonitor(this.format, (long)maxDurationSeconds * 1000L, longAudioAction == null ? () -> {} : longAudioAction);
    }

    @NotNull
    private SilenceFilter buildSilenceFilter(@Nullable Runnable longSilenceAction) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        int silenceTimeout = CommonUtils.toInt((Object)store.getString("ai.transcript.silence.timeout"), (int)20);
        return new SilenceFilter(46.0f, 3.5f, this.format, (long)silenceTimeout * 1000L, longSilenceAction == null ? () -> {} : longSilenceAction, (Executor)this.executor);
    }
}

