/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.controls.MessageComposite;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPCloseableNE;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;

final class StandardMessageList
extends Composite {
    private static final String CSS_ID = "ai-chat";
    private final AIChatControl chat;
    private Loader loader;

    StandardMessageList(@NotNull AIChatControl chat, @NotNull Composite parent) {
        super(parent, 0);
        this.chat = chat;
        this.chat.getChatSession().addListener((AIChatListener)new AIChatListenerImpl());
        this.setLayout((Layout)new GridLayout(1, false));
        this.addPaintListener(e -> {
            if (!chat.hasMessages()) {
                e.gc.setForeground(UIStyles.getDefaultTextForeground());
                UIUtils.drawMessageOverControl((Control)this, (PaintEvent)e, (String)AIChatMessages.ai_chat_empty_hint, (int)0);
            }
        });
        CSSUtils.setCSSClass((Widget)this, (String)CSS_ID);
    }

    private void addMessageControl(@NotNull AIChatMessage message) {
        if (message.message().getRole() == AIMessageType.SYSTEM) {
            return;
        }
        boolean isTheFirst = this.getChildren().length == 0;
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        switch (message.message().getRole()) {
            case USER: {
                layout.marginLeft = 20;
                break;
            }
            case ASSISTANT: {
                layout.marginRight = 20;
            }
        }
        Composite holder = new Composite((Composite)this, 0);
        holder.setData((Object)message);
        holder.setLayout((Layout)layout);
        holder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        AIFunctionResult functionResult = message.message().getFunctionResult();
        List<Object> chunks = functionResult != null && functionResult.getCallback() != null ? List.of(new MessageChunk.Link(message.message().getDisplayMessage(), functionResult.getCallback())) : List.of(AITextUtils.splitIntoChunks((String)message.message().getDisplayMessage(), (boolean)true));
        if (message.message().getRole() == AIMessageType.ASSISTANT && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.executeImmediately")) {
            List<MessageChunk.Code> codes = chunks.stream().filter(MessageChunk.Code.class::isInstance).map(MessageChunk.Code.class::cast).toList();
            if (codes.size() == 1) {
                this.chat.getController().executeInEditor(codes.getFirst().text());
            }
        }
        new MessageComposite(this.chat, holder, message, chunks, isTheFirst);
        this.layoutComposite();
    }

    private void removeMessageControl(@NotNull AIChatMessage message) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() == message) {
                child.dispose();
                this.layoutComposite();
                break;
            }
            ++n2;
        }
    }

    private void layoutComposite() {
        ScrolledComposite parent = (ScrolledComposite)this.getParent();
        Point size = parent.getSize();
        parent.setMinSize(this.computeSize(size.x, -1));
        parent.layout(true, true);
        UIUtils.asyncExec(() -> {
            if (!parent.isDisposed()) {
                parent.setOrigin(0, Integer.MAX_VALUE);
            }
        });
        this.redraw();
    }

    private class AIChatListenerImpl
    implements AIChatListener {
        private AIChatListenerImpl() {
        }

        public void messageAdded(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
            StandardMessageList.this.addMessageControl(message);
        }

        public void messageRemoved(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
            StandardMessageList.this.removeMessageControl(message);
        }

        public void conversationChanged(@NotNull AIChatConversation conversation) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DBPCloseableNE ignored = UIUtils.disableRedraw((Control)StandardMessageList.this);){
                Control[] controlArray = StandardMessageList.this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                for (AIChatMessage message : conversation.getMessages()) {
                    StandardMessageList.this.addMessageControl(message);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void busyChanged(boolean busy) {
            if (StandardMessageList.this.loader != null) {
                StandardMessageList.this.loader.dispose();
                StandardMessageList.this.loader = null;
            }
            if (busy) {
                AIEngineDescriptor descriptor = AIUtils.getActiveEngineDescriptor();
                StandardMessageList.this.loader = new Loader(StandardMessageList.this);
                StandardMessageList.this.loader.setText(NLS.bind((String)"Waiting for {0}", (Object)(descriptor == null ? "AI agent" : descriptor.getLabel())));
            }
            StandardMessageList.this.layoutComposite();
        }
    }

    private static class Loader
    extends Composite {
        private final Label label;

        public Loader(@NotNull Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
            Spinner spinner = new Spinner(this);
            this.label = new Label((Composite)this, 0);
            this.label.setLayoutData((Object)new GridData(768));
            WidgetElement.setCSSClass((Widget)spinner, (String)"progress_spinner");
            WidgetElement.setCSSClass((Widget)this.label, (String)"progress_spinner");
        }

        void setText(@NotNull String message) {
            this.label.setText(message);
        }
    }

    private static class Spinner
    extends Composite {
        private static final int REVOLUTIONS_PER_SECOND = 1;
        private static final int FRAME_TIME = 1000 / UIIcon.LOADING.size() / 1;

        public Spinner(@NotNull Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new FillLayout());
            final Label label = new Label((Composite)this, 0);
            label.setImage(DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.getFirst())));
            AbstractUIJob job = new AbstractUIJob("Paint progress"){
                private int index;
                {
                    super($anonymous0);
                    this.index = 0;
                }

                protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                    if (!label.isDisposed()) {
                        this.index = (this.index + 1) % UIIcon.LOADING.size();
                        label.setImage(DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.get(this.index))));
                        this.schedule(FRAME_TIME);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }
}

