/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.ui.ai.chat.AIChatUtils;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.controls.WebCSSInitializer;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.convert.impl.HTMLSQLConverter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;
import org.jkiss.dbeaver.utils.RuntimeUtils;

final class WebViewMessageList
extends Composite {
    private static final Gson GSON = new Gson();
    private static final Log log = Log.getLog(WebViewMessageList.class);
    private final Browser browser;
    private AIChatConversation conversation;
    private boolean isInitWaiting = true;
    private SQLSyntaxManager syntaxManager;
    private SQLRuleManager ruleManager;
    private SQLRuleScanner ruleScanner;

    WebViewMessageList(final @NotNull AIChatControl chat, @NotNull Composite parent) throws IOException {
        super(parent, 0);
        chat.getChatSession().addListener(new AIChatListener(){

            public void messageAdded(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                WebViewMessageList.this.addMessage(message);
            }

            public void messageRemoved(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                WebViewMessageList.this.removeMessage(message);
            }

            public void conversationChanged(@NotNull AIChatConversation conversation) {
                WebViewMessageList.this.setConversation(conversation, false);
            }

            public void busyChanged(boolean busy) {
                WebViewMessageList.this.execute("setBusy", Map.of("busy", busy));
            }
        });
        this.setLayoutData(new GridData(4, 4, true, true));
        this.setLayout((Layout)new FillLayout());
        WebCSSInitializer cssInitializer = new WebCSSInitializer();
        this.browser = new Browser((Composite)this, 0);
        this.browser.setJavascriptEnabled(true);
        this.browser.setVisible(false);
        this.browser.setUrl(cssInitializer.getWebHtmlPath());
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> {
            this.browser.setVisible(true);
            this.isInitWaiting = false;
            this.initChat();
            if (this.conversation != null) {
                this.setConversation(this.conversation, true);
            }
        }));
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String url = event.location;
                if (this.shouldOpenExternally(url)) {
                    event.doit = false;
                    Program.launch((String)url);
                }
            }

            private boolean shouldOpenExternally(String url) {
                return url.startsWith("http://") || url.startsWith("https://");
            }
        });
        new BrowserFunction(this.browser, "setClipboardContents"){

            public Object function(Object[] arguments) {
                AIChatUtils.copyToClipboard(WebViewMessageList.this.getDisplay(), arguments[0].toString());
                return null;
            }
        };
        new BrowserFunction(this.browser, "executeInEditor"){

            public Object function(Object[] arguments) {
                AIChatUtils.executeInEditor(chat.getController(), arguments[0].toString());
                return null;
            }
        };
        new BrowserFunction(this.browser, "openInEditor"){

            public Object function(Object[] arguments) {
                int id = Integer.parseInt(arguments[1].toString());
                Optional<AIChatMessage> message = WebViewMessageList.this.conversation.getMessages().stream().filter(aiChatMessage -> aiChatMessage.id() == id).findFirst();
                if (message.isEmpty()) {
                    log.warn((Object)("Message with id " + id + " not found in conversation"));
                } else {
                    AIMessage msg = message.get().message();
                    AIChatUtils.openInEditor(chat, arguments[0].toString(), msg);
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "clearToHere"){

            public Object function(Object[] arguments) {
                int id;
                Object object = arguments[0];
                if (object instanceof Number) {
                    Number argument = (Number)object;
                    id = argument.intValue();
                } else {
                    id = Integer.parseInt(arguments[0].toString());
                }
                Optional<AIChatMessage> message = WebViewMessageList.this.conversation.getMessages().stream().filter(aiChatMessage -> aiChatMessage.id() == id).findFirst();
                if (message.isEmpty()) {
                    log.warn((Object)("Message with id " + id + " not found in conversation"));
                } else {
                    UIUtils.asyncExec(() -> AIChatUtils.clearToHere(chat.getChatSession(), WebViewMessageList.this.conversation, (AIChatMessage)message.get()));
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "executeFunction"){

            public Object function(Object[] arguments) {
                int id;
                Object object = arguments[0];
                if (object instanceof Number) {
                    Number argument = (Number)object;
                    id = argument.intValue();
                } else {
                    id = Integer.parseInt(arguments[0].toString());
                }
                Optional<AIChatMessage> message = WebViewMessageList.this.conversation.getMessages().stream().filter(aiChatMessage -> aiChatMessage.id() == id).findFirst();
                if (message.isEmpty()) {
                    log.warn((Object)("Message with id " + id + " not found in conversation"));
                } else if (message.get().message().getFunctionResult() == null || message.get().message().getFunctionResult().getCallback() == null) {
                    log.error((Object)("Message with id " + id + " don't have function"));
                } else {
                    try {
                        message.get().message().getFunctionResult().getCallback().runTask((DBRProgressMonitor)new VoidProgressMonitor());
                    }
                    catch (DBException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    @Nullable
    private DBPDataSource getDataSource() {
        return this.conversation.getDataSource() == null ? null : this.conversation.getDataSource().getDataSource();
    }

    private void setConversation(@NotNull AIChatConversation conversation, boolean forceUpdateContext) {
        AIChatConversation oldConversation = this.conversation;
        this.conversation = conversation;
        if (this.isInitWaiting) {
            return;
        }
        if (forceUpdateContext || this.isDatasourceChanged(oldConversation, conversation)) {
            this.updateSQLParserContext();
        }
        this.clearChat();
        conversation.getMessages().forEach(this::addMessage);
        if (conversation.getMessages().isEmpty()) {
            this.showEmptyChat();
        }
    }

    private boolean isDatasourceChanged(@Nullable AIChatConversation oldConversation, @NotNull AIChatConversation newConversation) {
        return oldConversation == null || oldConversation.getDataSource() != newConversation.getDataSource();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addMessage(@NotNull AIChatMessage message) {
        DBPImage icon = AIChatUtils.getRoleIcon(message.message());
        String iconPath = "";
        try {
            iconPath = RuntimeUtils.getPlatformFile((String)icon.getLocation()).getPath();
        }
        catch (IOException e) {
            log.error((Object)("Error getting icon path for " + String.valueOf(icon)), (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        if (message.message().getFunctionResult() != null && message.message().getFunctionResult().getCallback() != null) {
            sb.append("<a class='interactive-link' data-message-id='").append(message.id()).append("'>").append(message.message().getDisplayMessage()).append("</a>");
        } else {
            MessageChunk[] chunks;
            String messageContent = message.message().getContent();
            MessageChunk[] messageChunkArray = chunks = AITextUtils.splitIntoChunks((String)messageContent, (boolean)false);
            int n = chunks.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    MessageChunk chunk = messageChunkArray[n2];
                    if (chunk instanceof MessageChunk.Code) {
                        block9: {
                            MessageChunk.Code code = (MessageChunk.Code)chunk;
                            try {
                                String text = code.text();
                                String codeBlockTag = code.language();
                                if (!codeBlockTag.equals("sql") && !codeBlockTag.isEmpty()) break block9;
                                sb.append("\n\n").append(this.convertSQLToHTML(text)).append("\n");
                                break block10;
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                        }
                        sb.append('\n').append(chunk.toRawString()).append('\n');
                    } else {
                        sb.append(chunk.toRawString());
                    }
                }
                ++n2;
            }
        }
        Map<String, String> args = Map.of("id", message.id(), "role", message.message().getRole().name().toLowerCase(Locale.ROOT), "icon", iconPath, "content", sb.toString(), "tooltipMessage", NLS.bind((String)AIChatMessages.ai_chat_message_info_tip, (Object)AIChatUtils.getRoleName(message.message()), (Object)AIChatUtils.formatMessageTime(message.message())));
        this.execute("addMessage", args);
    }

    private void initChat() {
        Map<String, Map<String, String>> icons = Map.of("copy", this.getActionData(UIIcon.FILTER_CLIPBOARD, AIChatMessages.ai_chat_message_copy_to_clipboard_tip), "execute", this.getActionData(UIIcon.SQL_EXECUTE, AIChatMessages.ai_chat_message_execute_query_tip), "editor", this.getActionData(UIIcon.LINK_TO_EDITOR, AIChatMessages.ai_chat_message_copy_to_editor_tip), "info", this.getActionData(DBIcon.SMALL_INFO, ""), "clean", this.getActionData(UIIcon.CLEAN, AIChatMessages.ai_chat_message_clear_up_to_here_tip));
        this.execute("initChat", icons);
    }

    @NotNull
    private Map<String, String> getActionData(@NotNull DBIcon icon, @NotNull String tooltipMessage) {
        Map<String, String> iconData;
        try {
            iconData = Map.of("icon", RuntimeUtils.getPlatformFile((String)icon.getLocation()).getPath(), "tooltip", tooltipMessage);
        }
        catch (IOException e) {
            log.error((Object)("Error getting icon path for " + String.valueOf(icon)), (Throwable)e);
            iconData = Map.of("icon", "", "tooltip", tooltipMessage);
        }
        return iconData;
    }

    private void addMessageChunk(@NotNull AIChatMessage message, @NotNull String chunk) {
        this.execute("addMessageChunk", Map.of("id", message.id(), "chunk", chunk));
    }

    private void removeMessage(@NotNull AIChatMessage message) {
        this.execute("removeMessage", Map.of("id", message.id()));
    }

    private void clearChat() {
        this.execute("clearChat", Map.of());
    }

    private void showEmptyChat() {
        this.execute("showCenterText", Map.of("text", AIChatMessages.ai_chat_empty_hint));
    }

    private void execute(@NotNull String function, @NotNull Map<String, ?> args) {
        this.browser.execute("%s(%s)".formatted(function, GSON.toJson(args)));
    }

    @NotNull
    private String convertSQLToHTML(@NotNull String sql) {
        DBPDataSource dataSource = this.getDataSource();
        HTMLSQLConverter converter = new HTMLSQLConverter();
        return converter.convertText(dataSource != null ? dataSource.getSQLDialect() : this.syntaxManager.getDialect(), this.syntaxManager, this.ruleScanner, (IDocument)new Document(sql), 0, sql.length(), Map.of("addCodeBlock", true));
    }

    private void updateSQLParserContext() {
        this.syntaxManager = new SQLSyntaxManager();
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            this.syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
        } else {
            this.syntaxManager.init(this.syntaxManager.getDialect(), this.syntaxManager.getPreferenceStore());
        }
        this.ruleScanner = new SQLRuleScanner();
        this.ruleManager = new SQLRuleManager(this.syntaxManager);
        this.ruleManager.loadRules(dataSource, false);
        if (dataSource != null) {
            this.ruleScanner.refreshRules(dataSource.getContainer(), this.ruleManager, null);
        } else {
            this.ruleScanner.refreshRules(null, this.ruleManager, null);
        }
    }
}

