/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.ollama;

import com.dbeaver.model.ai.engine.ollama.OllamaClient;
import com.dbeaver.model.ai.engine.ollama.OllamaProperties;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaModel;
import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class OllamaConfigurator
implements AIIObjectPropertyConfigurator<AIEngineDescriptor, OllamaProperties> {
    private String hostname = "";
    private boolean logQuery = false;
    private Button logQueryCheck;
    private String temperature = "";
    private String model = "";
    private String contextSize = "";
    private Text hostnameText;
    private Text temperatureText;
    private Text contextSizeText;
    private Combo modelCombo;
    private Button listModelsButton;

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite upperComposite = UIUtils.createComposite((Composite)parent, (int)2);
        upperComposite.setLayoutData((Object)new GridData(768));
        this.hostnameText = UIUtils.createLabelText((Composite)upperComposite, (String)AIUIAdvancedMessages.ollama_preference_page_hostname, (String)"", (int)2048);
        this.hostnameText.setLayoutData((Object)new GridData(768));
        this.hostnameText.addModifyListener(e -> {
            this.hostname = this.hostnameText.getText();
            if (this.listModelsButton != null && !this.listModelsButton.isDisposed()) {
                this.modelCombo.setItems(new String[0]);
                this.modelCombo.setEnabled(false);
                this.updateModel();
            }
        });
        this.hostnameText.setMessage(AIUIAdvancedMessages.ollama_preference_page_hostname);
        Composite comboComposite = UIUtils.createComposite((Composite)parent, (int)3);
        comboComposite.setLayoutData((Object)new GridData(768));
        this.modelCombo = UIUtils.createLabelCombo((Composite)comboComposite, (String)AIUIAdvancedMessages.ollama_preference_page_model, (String)"", (int)2056);
        this.modelCombo.setLayoutData((Object)new GridData(768));
        this.modelCombo.setEnabled(false);
        this.modelCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.model = this.modelCombo.getText();
        }));
        this.listModelsButton = UIUtils.createPushButton((Composite)comboComposite, null, (String)"Load models", (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshModels()));
        Composite bottomComposite = UIUtils.createComposite((Composite)parent, (int)2);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.contextSizeText = UIUtils.createLabelText((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_context_size, (String)"", (int)2048);
        this.contextSizeText.setLayoutData((Object)new GridData(768));
        this.contextSizeText.addModifyListener(e -> {
            String string = this.contextSize = this.contextSizeText.getText();
        });
        this.contextSizeText.setMessage(AIUIAdvancedMessages.ollama_preference_page_context_size);
        this.contextSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText = UIUtils.createLabelText((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
        this.temperatureText.setToolTipText(AIUIAdvancedMessages.ollama_preference_page_temperature_info);
        this.logQueryCheck = UIUtils.createCheckbox((Composite)bottomComposite, (String)AIUIAdvancedMessages.ollama_preference_page_text_debug, (String)AIUIAdvancedMessages.ollama_preference_page_text_debug_tip, (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.logQuery = this.logQueryCheck.getSelection();
        }));
        UIUtils.syncExec(this::applySettings);
    }

    private void refreshModels() {
        new AbstractJob("Listing models"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (OllamaClient ollama = new OllamaClient(OllamaConfigurator.this.hostname);){
                        List<String> models = ollama.loadModels(monitor).stream().map(OllamaModel::name).toList();
                        UIUtils.syncExec(() -> {
                            OllamaConfigurator.this.modelCombo.setItems(models.toArray(new String[0]));
                            OllamaConfigurator.this.modelCombo.setEnabled(true);
                            int i = 0;
                            while (i < models.size()) {
                                if (((String)models.get(i)).equals(OllamaConfigurator.this.model)) {
                                    OllamaConfigurator.this.modelCombo.select(i);
                                }
                                ++i;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    UIUtils.syncExec(() -> {
                        DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError("Error reading model list", "Failed to read Ollama model list", (Throwable)ex);
                    });
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void loadSettings(@NotNull OllamaProperties configuration) {
        this.hostname = CommonUtils.toString((Object)configuration.getHostname(), (String)"");
        this.contextSizeText.setText(CommonUtils.toString((Object)configuration.getContextWindowSize(), (String)""));
        this.model = CommonUtils.toString((Object)configuration.getModel(), (String)"");
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.applySettings();
    }

    public void saveSettings(@NotNull OllamaProperties configuration) {
        configuration.setHostname(this.hostname);
        configuration.setModel(this.model);
        configuration.setContextWindowSize(Integer.parseInt(this.contextSize));
        configuration.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        configuration.setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull OllamaProperties ollamaPropertiesLegacyAISettings) {
    }

    private void updateModel() {
        try {
            new URL(this.hostname);
            this.listModelsButton.setEnabled(true);
        }
        catch (Exception exception) {
            this.listModelsButton.setEnabled(false);
        }
    }

    protected void applySettings() {
        this.hostnameText.setText(this.hostname);
        this.temperatureText.setText(this.temperature);
        this.updateModel();
        if (this.listModelsButton.isEnabled()) {
            this.modelCombo.setItems(new String[]{this.model});
            this.modelCombo.select(0);
        }
        this.contextSizeText.setText(this.contextSize);
        this.logQueryCheck.setSelection(this.logQuery);
        this.updateModel();
    }

    public boolean isComplete() {
        return !this.hostnameText.getText().isEmpty() && !this.modelCombo.getText().isEmpty() && !this.contextSizeText.getText().isEmpty();
    }
}

