/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.format;

import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.AISqlJoinRule;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.format.DefaultFormattingConfigurator;
import org.jkiss.utils.CommonUtils;

public class AdvancedFormattingConfigurator
extends DefaultFormattingConfigurator {
    private Combo joinTypeCombo;
    private Button formatQueryCheck;
    private Button sendConstraintsCheck;
    private Button sendForeignKeysCheck;
    private Button enableAISuggestion;
    private Button ragEnabledButton;

    public void createControl(@NotNull Composite parent, AISchemaGenerator object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, object, propertyChangeListener);
        GridData gridData = GridDataFactory.createFrom((GridData)((GridData)this.settingsPanel.getLayoutData())).span(2, 2).create();
        this.settingsPanel.setLayoutData((Object)gridData);
    }

    protected void createRightPanel(Composite rightPanel) {
        super.createRightPanel(rightPanel);
        this.createRAGSettings(rightPanel);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        super.loadSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.enableAISuggestion.setSelection(store.getBoolean("ai.enableSuggestion"));
        this.sendForeignKeysCheck.setSelection(store.getBoolean("ai.useForeignKeys"));
        this.sendConstraintsCheck.setSelection(store.getBoolean("ai.useConstraints"));
        this.formatQueryCheck.setSelection(store.getBoolean("ai.formatSqlQuery"));
        AISqlJoinRule jr = (AISqlJoinRule)CommonUtils.valueOf(AISqlJoinRule.class, (String)store.getString("ai.joinRule"), (Enum)AISqlJoinRule.DEFAULT);
        this.joinTypeCombo.select(jr.ordinal());
        AISettingsManager settingsManager = AISettingsManager.getInstance();
        AISettings settings = settingsManager.getSettings();
        this.ragEnabledButton.setSelection(((Boolean)settings.getProperty("ai.rag.enabled", (Object)false)).booleanValue());
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        super.createAppearanceSettings(appearanceGroup, propertyChangeListener);
        this.formatQueryCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_query_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_query_tip, (boolean)false, (int)2);
        this.joinTypeCombo = UIUtils.createLabelCombo((Composite)appearanceGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_join_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_format_join_tip, (int)12);
        this.joinTypeCombo.setLayoutData((Object)new GridData(32));
        AISqlJoinRule[] aISqlJoinRuleArray = AISqlJoinRule.values();
        int n = aISqlJoinRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AISqlJoinRule jr = aISqlJoinRuleArray[n2];
            this.joinTypeCombo.add(jr.getTitle());
            ++n2;
        }
        this.joinTypeCombo.select(0);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        super.createCompletionSettings(completionGroup, propertyChangeListener);
        this.enableAISuggestion = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_enable_ai_suggestion_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_enable_ai_suggestion_tip, (boolean)true, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        super.createSchemaSettings(schemaGroup);
        this.sendForeignKeysCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_foreign_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_foreign_tip, (boolean)false, (int)2);
        this.sendConstraintsCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_constrains_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_constrains_tip, (boolean)false, (int)2);
    }

    public void createRAGSettings(Composite rightPanel) {
        Group schemaGroup = UIUtils.createControlGroup((Composite)rightPanel, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_scope_group, (int)2, (int)0, (int)5);
        schemaGroup.setLayoutData((Object)new GridData(770));
        this.ragEnabledButton = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_scope_rag_enabled, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_scope_rag_enabled_tip, (boolean)false, (int)2);
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        super.saveSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.enableSuggestion", this.enableAISuggestion.getSelection());
        store.setValue("ai.useForeignKeys", this.sendForeignKeysCheck.getSelection());
        store.setValue("ai.useConstraints", this.sendConstraintsCheck.getSelection());
        store.setValue("ai.formatSqlQuery", this.formatQueryCheck.getSelection());
        store.setValue("ai.joinRule", ((AISqlJoinRule)CommonUtils.fromOrdinal(AISqlJoinRule.class, (int)this.joinTypeCombo.getSelectionIndex())).name());
        AISettings settings = AISettingsManager.getInstance().getSettings();
        settings.setProperty("ai.rag.enabled", (Object)this.ragEnabledButton.getSelection());
        AISettingsManager.getInstance().saveSettings(settings);
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
        super.resetSettings(aiSettings);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setToDefault("ai.useConstraints");
        store.setToDefault("ai.useForeignKeys");
        store.setToDefault("ai.joinRule");
        store.setToDefault("ai.formatSqlQuery");
        store.setToDefault("ai.enableSuggestion");
        store.setToDefault("ai.chat.webRenderer");
    }

    public boolean isComplete() {
        return super.isComplete();
    }
}

