/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.utils.CommonUtils;

public class AIFunctionCloseEditor
implements AIFunction {
    private static final Log log = Log.getLog(AIFunctionCloseEditor.class);
    public static final String PARAM_EDITOR_TYPE = "editorType";
    public static final String PARAM_EDITOR_ID = "editorId";
    public static final String PARAM_EDITOR_NAME = "editorName";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String editorType = JSONUtils.getString(parameters, (String)PARAM_EDITOR_TYPE);
        if (CommonUtils.isEmpty((String)editorType)) {
            throw new DBException("Editor type parameter is required");
        }
        String editorId = JSONUtils.getString(parameters, (String)PARAM_EDITOR_ID);
        if (CommonUtils.isEmpty((String)editorId)) {
            throw new DBException("Editor identifier parameter is required");
        }
        String editorName = JSONUtils.getString(parameters, (String)PARAM_EDITOR_NAME);
        if (CommonUtils.isEmpty((String)editorName)) {
            throw new DBException("Editor name parameter is required");
        }
        AIFunctionResult functionResult = switch (editorType) {
            case "sql" -> this.closeSQLEditor(editorId, editorName);
            case "editor" -> this.closeDatabaseObjectEditor(editorId, editorName);
            default -> throw new DBException("Unknown editor type: " + editorType);
        };
        functionResult.getCallback().runTask(context.getMonitor());
        return functionResult;
    }

    @NotNull
    private AIFunctionResult closeSQLEditor(@NotNull String filePath, @NotNull String editorName) {
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> {
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    IEditorReference[] editorReferences;
                    IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block5: {
                            IEditorReference editorRef = iEditorReferenceArray[n2];
                            try {
                                IFileEditorInput fileEditorInput;
                                String editorFilePath;
                                IEditorInput editorInput = editorRef.getEditorInput();
                                if (!(editorInput instanceof IFileEditorInput) || !filePath.equals(editorFilePath = (fileEditorInput = (IFileEditorInput)editorInput).getFile().getFullPath().toString())) break block5;
                                activePage.closeEditor(editorRef.getEditor(false), false);
                                break;
                            }
                            catch (Exception e) {
                                log.error((Object)"Error accessing editor input", (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                } else {
                    log.error((Object)"No active workbench page found");
                }
            });
            return null;
        };
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Close " + editorName + " SQL editor", callback);
    }

    @NotNull
    private AIFunctionResult closeDatabaseObjectEditor(@NotNull String nodePath, @NotNull String editorName) throws DBException {
        boolean[] isFound = new boolean[1];
        UIUtils.syncExec(() -> {
            IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IEditorReference[] editorReferences;
                IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorRef = iEditorReferenceArray[n2];
                    try {
                        IDatabaseEditorInput databaseEditorInput;
                        IEditorInput editorInput = editorRef.getEditorInput();
                        if (editorInput instanceof IDatabaseEditorInput && nodePath.equals((databaseEditorInput = (IDatabaseEditorInput)editorInput).getNodePath())) {
                            blArray[0] = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error accessing editor input", (Throwable)e);
                    }
                    ++n2;
                }
            }
        });
        if (!isFound[0]) {
            throw new DBException("Cannot find " + editorName + " editor");
        }
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> {
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    IEditorReference[] editorReferences;
                    IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block5: {
                            IEditorReference editorRef = iEditorReferenceArray[n2];
                            try {
                                IDatabaseEditorInput databaseEditorInput;
                                IEditorInput editorInput = editorRef.getEditorInput();
                                if (!(editorInput instanceof IDatabaseEditorInput) || !nodePath.equals((databaseEditorInput = (IDatabaseEditorInput)editorInput).getNodePath())) break block5;
                                activePage.closeEditor(editorRef.getEditor(false), false);
                                break;
                            }
                            catch (Exception e) {
                                log.error((Object)"Error accessing editor input", (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                } else {
                    log.error((Object)"No active workbench page found");
                }
            });
            return null;
        };
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Close " + editorName + " editor", callback);
    }
}

