/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

public class AIFunctionGetAllDrivers
implements AIFunction {
    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        List drivers = registry.getDataSourceProviders().stream().flatMap(provider -> provider.getEnabledDrivers().stream()).toList();
        LinkedHashMap<String, List<Map>> result = new LinkedHashMap<String, List<Map>>();
        result.put("drivers", drivers.stream().map(driver -> {
            LinkedHashMap<String, String> driverInfo = new LinkedHashMap<String, String>();
            driverInfo.put("id", driver.getId());
            driverInfo.put("name", driver.getName());
            driverInfo.put("description", driver.getDescription());
            return driverInfo;
        }).toList());
        return new AIFunctionResult(AIFunctionResult.FunctionType.INFORMATION, ((Object)result).toString());
    }
}

