/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.preferences;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionCategoryDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class AIFunctionCategoriesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(AIFunctionCategoriesPreferencePage.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.ai.functions";
    private CheckboxTreeViewer treeViewer;
    private Map<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> categoryMap;
    private Set<String> enabledCategories;
    private Set<String> enabledFunctions;

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return AISettingsManager.getInstance().getSettings();
    }

    public void setElement(IAdaptable element) {
    }

    protected Control createContents(Composite parent) {
        if (!this.hasAccessToConfiguration()) {
            return UIUtils.createLabel((Composite)parent, (String)UIMessages.preference_page_no_access);
        }
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createLabel((Composite)composite, (String)"Configure available AI function categories and functions:");
        this.treeViewer = new CheckboxTreeViewer(composite, 67616);
        GridData gd = new GridData(1808);
        gd.heightHint = 340;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        try {
            this.loadData();
            this.loadState();
            this.treeViewer.setCheckStateProvider((ICheckStateProvider)new StateProvider());
            this.treeViewer.setInput(this.categoryMap);
            this.treeViewer.expandAll();
        }
        catch (Exception e) {
            log.error((Object)"Error loading AI functions", (Throwable)e);
            UIUtils.createLabel((Composite)composite, (String)("Error loading AI functions: " + e.getMessage()));
        }
        this.treeViewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (element instanceof AIFunctionCategoryDescriptor) {
                AIFunctionCategoryDescriptor cat = (AIFunctionCategoryDescriptor)element;
                List fns = this.categoryMap.getOrDefault(cat, List.of());
                if (checked) {
                    for (AIFunctionDescriptor f : fns) {
                        this.enabledFunctions.add(f.getId());
                    }
                } else {
                    for (AIFunctionDescriptor f : fns) {
                        this.enabledFunctions.remove(f.getId());
                    }
                }
                if (checked && this.allFunctionsEnabled(cat)) {
                    this.enabledCategories.add(cat.getId());
                } else {
                    this.enabledCategories.remove(cat.getId());
                }
            } else if (element instanceof AIFunctionDescriptor) {
                AIFunctionDescriptor fn = (AIFunctionDescriptor)element;
                if (checked) {
                    this.enabledFunctions.add(fn.getId());
                } else {
                    this.enabledFunctions.remove(fn.getId());
                }
                AIFunctionCategoryDescriptor cat = this.findCategoryOf(fn);
                if (cat != null) {
                    if (this.allFunctionsEnabled(cat)) {
                        this.enabledCategories.add(cat.getId());
                    } else {
                        this.enabledCategories.remove(cat.getId());
                    }
                }
            }
            this.treeViewer.refresh();
        });
        return composite;
    }

    private boolean hasAccessToConfiguration() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }

    private void loadData() {
        this.categoryMap = new LinkedHashMap<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>>();
        AIFunctionRegistry registry = AIFunctionRegistry.getInstance();
        Map byCat = registry.getFunctionsByCategory();
        for (Map.Entry e : byCat.entrySet()) {
            ArrayList<AIFunctionDescriptor> list = new ArrayList<AIFunctionDescriptor>();
            for (AIFunctionDescriptor fd : (List)e.getValue()) {
                if (fd.isHidden()) continue;
                list.add(fd);
            }
            list.sort(Comparator.comparing(AIFunctionDescriptor::getName, String.CASE_INSENSITIVE_ORDER));
            this.categoryMap.put((AIFunctionCategoryDescriptor)e.getKey(), list);
        }
    }

    private void loadState() {
        AISettings aiSettings = AISettingsManager.getInstance().getSettings();
        this.enabledCategories = new HashSet<String>(aiSettings.getEnabledFunctionCategories());
        this.enabledFunctions = new HashSet<String>(aiSettings.getEnabledFunctions());
    }

    private boolean allFunctionsEnabled(@NotNull AIFunctionCategoryDescriptor cat) {
        List fns = this.categoryMap.getOrDefault(cat, List.of());
        if (fns.isEmpty()) {
            return false;
        }
        for (AIFunctionDescriptor f : fns) {
            if (this.enabledFunctions.contains(f.getId())) continue;
            return false;
        }
        return true;
    }

    private AIFunctionCategoryDescriptor findCategoryOf(AIFunctionDescriptor f) {
        String cid = f.getCategoryId();
        if (CommonUtils.isEmpty((String)cid)) {
            return null;
        }
        for (AIFunctionCategoryDescriptor c : this.categoryMap.keySet()) {
            if (!cid.equals(c.getId())) continue;
            return c;
        }
        return null;
    }

    public boolean performOk() {
        if (!this.hasAccessToConfiguration()) {
            return false;
        }
        try {
            AISettings s = AISettingsManager.getInstance().getSettings();
            s.setEnabledFunctionCategories(this.enabledCategories);
            s.setEnabledFunctions(this.enabledFunctions);
            AISettingsManager.getInstance().saveSettings(s);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Failed to save AI function settings", (Throwable)e);
            return false;
        }
    }

    protected void performDefaults() {
        if (!this.hasAccessToConfiguration()) {
            return;
        }
        this.enabledCategories.clear();
        this.enabledFunctions.clear();
        for (Map.Entry<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> e : this.categoryMap.entrySet()) {
            AIFunctionCategoryDescriptor cat = e.getKey();
            if (!cat.isEnabledByDefault()) continue;
            this.enabledCategories.add(cat.getId());
            for (AIFunctionDescriptor f : e.getValue()) {
                this.enabledFunctions.add(f.getId());
            }
        }
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        super.performDefaults();
    }

    private class StateProvider
    implements ICheckStateProvider {
        private StateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof AIFunctionDescriptor) {
                AIFunctionDescriptor f = (AIFunctionDescriptor)element;
                return AIFunctionCategoriesPreferencePage.this.enabledFunctions.contains(f.getId()) || AIFunctionCategoriesPreferencePage.this.enabledCategories.contains(f.getCategoryId());
            }
            if (element instanceof AIFunctionCategoryDescriptor) {
                AIFunctionCategoryDescriptor c = (AIFunctionCategoryDescriptor)element;
                return AIFunctionCategoriesPreferencePage.this.enabledCategories.contains(c.getId());
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            if (element instanceof AIFunctionCategoryDescriptor) {
                AIFunctionCategoryDescriptor c = (AIFunctionCategoryDescriptor)element;
                List fns = AIFunctionCategoriesPreferencePage.this.categoryMap.getOrDefault(c, List.of());
                if (fns.isEmpty()) {
                    return false;
                }
                int on = 0;
                for (AIFunctionDescriptor f : fns) {
                    if (!this.isChecked(f)) continue;
                    ++on;
                }
                return on > 0 && on < fns.size();
            }
            return false;
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return AIFunctionCategoriesPreferencePage.this.categoryMap.keySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AIFunctionCategoryDescriptor) {
                AIFunctionCategoryDescriptor category = (AIFunctionCategoryDescriptor)parentElement;
                List<AIFunctionDescriptor> functions = AIFunctionCategoriesPreferencePage.this.categoryMap.get(category);
                return functions != null ? functions.toArray() : new Object[]{};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AIFunctionDescriptor) {
                AIFunctionDescriptor function = (AIFunctionDescriptor)element;
                return AIFunctionCategoriesPreferencePage.this.findCategoryOf(function);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof AIFunctionCategoryDescriptor;
        }
    }

    private static class TreeLabelProvider
    extends LabelProvider {
        private TreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof AIFunctionCategoryDescriptor) {
                AIFunctionCategoryDescriptor c = (AIFunctionCategoryDescriptor)element;
                return c.getName();
            }
            if (element instanceof AIFunctionDescriptor) {
                AIFunctionDescriptor f = (AIFunctionDescriptor)element;
                return f.getName();
            }
            return super.getText(element);
        }
    }
}

