/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.aws;

import com.dbeaver.net.auth.aws.AWSAuthType;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSRDS;
import com.dbeaver.ui.auth.aws.AuthModelAWSMessages;
import com.dbeaver.ui.auth.aws.prefs.PrefPageAwsConfiguration;
import com.dbeaver.ui.auth.cloud.AuthModelCloudConfigurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;

public class AuthModelAWSConfigurator
extends AuthModelCloudConfigurator {
    private static final Log log = Log.getLog(AuthModelAWSConfigurator.class);
    private Label regionLabel;
    private Combo regionCombo;
    private Label authTypeLabel;
    private Composite authTypeGroup;
    private Combo authTypeCombo;
    private final List<AWSAuthType> authTypes = new ArrayList<AWSAuthType>();
    private Label awsAccessKeyLabel;
    private Text awsAccessKeyText;
    private Label awsSecretKeyLabel;
    private Label awsSessionTokenLabel;
    private Text awsSecretKeyText;
    private Text awsSessionTokenText;
    private Button awsSaveKeysCheck;
    private Label awsProfileNameLabel;
    private Combo awsProfileNameCombo;
    private Control awsProfileFiller;
    private Composite ssoGroup;
    private Button iamSSOCheckbox;
    private Link ssoDocsLink;
    private Link ssoPrefLink;
    private Text iamRoleNameText;
    private Text rdsHostNameText;
    private Button use3rdPartyAccessCheckbox;
    private Button useAwsSecretsManagerCheckbox;
    private Label iamAccountIdLabel;
    private Text iamAccountIdText;
    private Label iamExternalIdLabel;
    private Text iamExternalIdText;
    protected AWSAuthType curConfigType = AWSAuthType.DEFAULT;
    protected boolean databaseConfiguration = true;
    protected boolean staticCredentials;
    private Label authTypeFiller;
    private Text iamSecretNameText;
    private Control iamSecretNameLabel;
    private Link awsCredDocsLink;
    private Label rdsHostNameLabel;

    public void setDatabaseConfiguration(boolean databaseConfiguration) {
        this.databaseConfiguration = databaseConfiguration;
    }

    protected AWSAuthType[] getSupportedAuthTypes() {
        ArrayList<AWSAuthType> authTypes = new ArrayList<AWSAuthType>();
        if (this.staticCredentials) {
            authTypes.add(AWSAuthType.KEY);
        } else if (DBWorkbench.isDistributed()) {
            Collections.addAll(authTypes, AWSAuthType.SESSION_CREDENTIALS, AWSAuthType.DEFAULT, AWSAuthType.PROFILE, AWSAuthType.KEY);
        } else {
            Collections.addAll(authTypes, AWSAuthType.DEFAULT, AWSAuthType.PROFILE, AWSAuthType.KEY);
        }
        if (this.databaseConfiguration) {
            authTypes.add(AWSAuthType.USER_PASSWORD);
        }
        return authTypes.toArray(new AWSAuthType[0]);
    }

    public AWSAuthType getAuthType() {
        return this.curConfigType;
    }

    public void setAuthType(AWSAuthType curConfigType) {
        this.curConfigType = curConfigType;
    }

    public void setStaticCredentials(boolean staticCredentials) {
        this.staticCredentials = staticCredentials;
    }

    protected boolean isPasswordApplicable() {
        return this.getAuthType() == AWSAuthType.USER_PASSWORD;
    }

    protected boolean isSavePasswordLocally() {
        return true;
    }

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        Composite iamGroup = parent;
        Composite authGroup = UIUtils.createComposite((Composite)iamGroup, (int)4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        authGroup.setLayoutData((Object)gd);
        this.createIAMAuthControls(authGroup, propertyChangeListener, this.databaseConfiguration);
        this.createCloudConfig(parent);
    }

    public void createIAMAuthControls(Composite iamGroup, final Runnable propertyChangeListener, boolean databaseConfig) {
        GridData gd;
        SelectionAdapter selChangeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        };
        boolean isWide = this.isWide(iamGroup);
        this.authTypeLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_auth_type);
        this.authTypeGroup = UIUtils.createComposite((Composite)iamGroup, (int)2);
        this.authTypeGroup.setLayoutData((Object)new GridData(768));
        this.authTypeCombo = new Combo(this.authTypeGroup, 12);
        this.authTypeCombo.setLayoutData((Object)new GridData(768));
        this.authTypeCombo.setToolTipText(AuthModelAWSMessages.model_iam_auth_type_tip);
        this.authTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AWSAuthType ct = AuthModelAWSConfigurator.this.authTypes.get(AuthModelAWSConfigurator.this.authTypeCombo.getSelectionIndex());
                AuthModelAWSConfigurator.this.changeAuthType(ct);
                propertyChangeListener.run();
            }
        });
        this.awsCredDocsLink = new Link(this.authTypeGroup, 0);
        this.awsCredDocsLink.setText("<a>Details</a>");
        this.awsCredDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"AWS-Credentials"));
            }
        });
        if (isWide) {
            this.authTypeFiller = new Label(iamGroup, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.authTypeFiller.setLayoutData((Object)gd);
        }
        this.awsProfileNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_profile_name);
        this.awsProfileNameCombo = new Combo(iamGroup, 12);
        gd = new GridData(768);
        this.awsProfileNameCombo.setLayoutData((Object)gd);
        this.awsProfileNameCombo.setToolTipText(AuthModelAWSMessages.model_iam_aws_profile_name_tip);
        try {
            for (Profile profile : ProfileFile.defaultProfileFile().profiles().values()) {
                this.awsProfileNameCombo.add(profile.name());
            }
        }
        catch (Throwable e2) {
            log.error((Object)"Error reading AWS profiles", e2);
        }
        this.awsProfileNameCombo.addSelectionListener((SelectionListener)selChangeListener);
        if (isWide) {
            this.awsProfileFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.createExtraIAMAuthSelectors(iamGroup, propertyChangeListener, isWide);
        if (databaseConfig) {
            this.usernameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_database_username);
            this.usernameLabel.setLayoutData((Object)new GridData(32));
            this.createUserNameControls(iamGroup, propertyChangeListener);
            gd = new GridData(768);
            this.usernameText.setLayoutData((Object)gd);
            this.usernameText.setMessage(AuthModelAWSMessages.model_iam_database_username_tip);
            this.regionLabel = new Label(iamGroup, 16384);
            this.regionLabel.setText(AuthModelAWSMessages.model_iam_region + ":");
            gd = new GridData(32);
            this.regionLabel.setLayoutData((Object)gd);
            this.regionCombo = new Combo(iamGroup, 4);
            gd = new GridData(768);
            this.regionCombo.setLayoutData((Object)gd);
            this.regionCombo.setToolTipText(AuthModelAWSMessages.model_iam_region_help);
        }
        this.createPasswordControls(iamGroup, propertyChangeListener);
        if (isWide) {
            ((GridData)this.passPlaceholder.getLayoutData()).horizontalSpan = 3;
        }
        this.awsAccessKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_access_key);
        this.awsAccessKeyText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Control)this.awsAccessKeyText) * 15;
        this.awsAccessKeyText.setLayoutData((Object)gd);
        this.awsAccessKeyText.setMessage(AuthModelAWSMessages.model_iam_aws_access_key_help);
        this.awsAccessKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSecretKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_secret_key);
        ((GridData)this.awsSecretKeyLabel.getLayoutData()).horizontalAlignment = 3;
        this.awsSecretKeyText = new Text(iamGroup, 0x400800);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Control)this.awsSecretKeyText) * 15;
        this.awsSecretKeyText.setLayoutData((Object)gd);
        this.awsSecretKeyText.setMessage(AuthModelAWSMessages.model_iam_aws_secret_key_help);
        this.awsSecretKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSessionTokenLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_session_token);
        ((GridData)this.awsSessionTokenLabel.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.awsSessionTokenLabel.getLayoutData()).verticalAlignment = 1;
        this.awsSessionTokenText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Control)this.awsSessionTokenText) * 15;
        this.awsSessionTokenText.setLayoutData((Object)gd);
        this.awsSessionTokenText.setMessage(AuthModelAWSMessages.model_iam_aws_session_token_help);
        this.awsSessionTokenText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSaveKeysCheck = UIUtils.createCheckbox((Composite)iamGroup, (String)"Save credentials", (String)"Save access/secret keys in local secured storage", (this.dataSource == null || this.dataSource.isSavePassword() || this.isForceSaveCredentials() ? 1 : 0) != 0, (int)2);
        this.awsSaveKeysCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password);
        this.awsSaveKeysCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelAWSConfigurator.this.enableAccessControls();
            }
        });
        this.awsSaveKeysCheck.setEnabled(!CREDENTIALS_SAVE_RESTRICTED && !this.isForceSaveCredentials());
        this.createExtraIAMAuthControls(iamGroup, propertyChangeListener, isWide);
        UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_role_name);
        this.iamRoleNameText = new Text(iamGroup, 2048);
        this.iamRoleNameText.setLayoutData((Object)new GridData(768));
        this.iamRoleNameText.setMessage(AuthModelAWSMessages.model_iam_aws_role_name_message);
        this.iamRoleNameText.setToolTipText(AuthModelAWSMessages.model_iam_aws_role_name_tip);
        this.rdsHostNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_rds_host_name);
        this.rdsHostNameText = new Text(iamGroup, 2048);
        this.rdsHostNameText.setLayoutData((Object)new GridData(768));
        this.rdsHostNameText.setMessage(AuthModelAWSMessages.model_rds_host_name_message);
        this.rdsHostNameText.setToolTipText(AuthModelAWSMessages.model_rds_host_name_tip);
        this.ssoGroup = UIUtils.createComposite((Composite)iamGroup, (int)3);
        gd = new GridData(768);
        gd.horizontalSpan = isWide ? 4 : 2;
        this.ssoGroup.setLayoutData((Object)gd);
        this.iamSSOCheckbox = UIUtils.createCheckbox((Composite)this.ssoGroup, (String)"Enable SSO", (String)"Enable Single Sign On (SSO) authorization using AWS CLI", (boolean)false, (int)1);
        this.iamSSOCheckbox.addSelectionListener((SelectionListener)selChangeListener);
        this.ssoDocsLink = new Link(this.ssoGroup, 0);
        this.ssoDocsLink.setText("<a>Instructions</a>");
        this.ssoDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"AWS-SSO"));
            }
        });
        this.ssoPrefLink = new Link(this.ssoGroup, 0);
        this.ssoPrefLink.setText("<a>Preferences</a>");
        this.ssoPrefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPageManager pageManager = new PropertyPageManager();
                pageManager.addToRoot((IPreferenceNode)new PreferenceNode("aws", (IPreferencePage)new PrefPageAwsConfiguration()));
                PropertyDialog pd = new PropertyDialog(UIUtils.getActiveWorkbenchShell(), (PreferenceManager)pageManager, (ISelection)new StructuredSelection());
                pd.open();
            }
        });
        this.use3rdPartyAccessCheckbox = UIUtils.createCheckbox((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_use_cross_account, (String)AuthModelAWSMessages.model_iam_use_cross_account_tip, (boolean)false, (int)4);
        this.use3rdPartyAccessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelAWSConfigurator.this.updateIAMSettingsVisibility();
            }
        });
        this.iamAccountIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_account_id);
        this.iamAccountIdText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        this.iamAccountIdText.setLayoutData((Object)gd);
        this.iamAccountIdText.setMessage(AuthModelAWSMessages.model_iam_aws_account_id_tip);
        this.iamExternalIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_external_id);
        this.iamExternalIdText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        this.iamExternalIdText.setLayoutData((Object)gd);
        this.iamExternalIdText.setMessage(AuthModelAWSMessages.model_iam_aws_external_id_tip);
        this.useAwsSecretsManagerCheckbox = UIUtils.createCheckbox((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_use_secrets, (String)AuthModelAWSMessages.model_iam_use_secrets_tip, (boolean)false, (int)4);
        this.useAwsSecretsManagerCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelAWSConfigurator.this.updateIAMSettingsVisibility();
            }
        });
        this.iamSecretNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelAWSMessages.model_iam_aws_secret_name);
        this.iamSecretNameText = new Text(iamGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.iamSecretNameText.setLayoutData((Object)gd);
        this.iamSecretNameText.setMessage(AuthModelAWSMessages.model_iam_aws_secret_name_tip);
        this.changeAuthType(this.curConfigType);
    }

    public boolean isWide(Composite iamGroup) {
        return ((GridLayout)iamGroup.getLayout()).numColumns > 2;
    }

    protected void createExtraIAMAuthSelectors(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    protected void createExtraIAMAuthControls(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    private void enableAccessControls() {
        this.awsAccessKeyText.setEnabled(CREDENTIALS_SAVE_RESTRICTED || this.awsSaveKeysCheck.getSelection());
        this.awsSecretKeyText.setEnabled(CREDENTIALS_SAVE_RESTRICTED || this.awsSaveKeysCheck.getSelection());
        this.awsSessionTokenText.setEnabled(CREDENTIALS_SAVE_RESTRICTED || this.awsSaveKeysCheck.getSelection());
    }

    private void changeAuthType(AWSAuthType ct) {
        this.curConfigType = ct;
        this.updateIAMSettingsVisibility();
    }

    protected void updateIAMSettingsVisibility() {
        UIUtils.setControlVisible((Control)this.savePasswordCheck, (!CREDENTIALS_SAVE_RESTRICTED && !this.isForceSaveCredentials() ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.authTypeLabel, (!this.isCloudProvided ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.authTypeGroup, (!this.isCloudProvided ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.awsCredDocsLink, (!this.isCloudProvided ? 1 : 0) != 0);
        if (this.authTypeFiller != null) {
            UIUtils.setControlVisible((Control)this.authTypeFiller, (!this.isCloudProvided ? 1 : 0) != 0);
        }
        if (this.passwordLabel != null) {
            boolean isPasswordVisible = this.isPasswordApplicable();
            UIUtils.setControlVisible((Control)this.passwordLabel, (boolean)isPasswordVisible);
            UIUtils.setControlVisible((Control)this.passPlaceholder, (boolean)isPasswordVisible);
        }
        boolean akVisible = !this.isCloudProvided && this.curConfigType == AWSAuthType.KEY;
        UIUtils.setControlVisible((Control)this.awsAccessKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsAccessKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSaveKeysCheck, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSessionTokenText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSessionTokenLabel, (boolean)akVisible);
        boolean pnVisible = !this.isCloudProvided && this.curConfigType == AWSAuthType.PROFILE;
        UIUtils.setControlVisible((Control)this.awsProfileNameLabel, (boolean)pnVisible);
        UIUtils.setControlVisible((Control)this.awsProfileNameCombo, (boolean)pnVisible);
        if (this.awsProfileFiller != null) {
            UIUtils.setControlVisible((Control)this.awsProfileFiller, (boolean)pnVisible);
        }
        this.updateExtraIAMSettingsVisibility();
        boolean isRdsConnection = this.databaseConfiguration;
        if (isRdsConnection && this.dataSource != null) {
            DBAAuthModel authModel = this.dataSource.getConnectionConfiguration().getAuthModel();
            isRdsConnection = authModel instanceof AuthModelAWSRDS;
        }
        UIUtils.setControlVisible((Control)this.rdsHostNameLabel, (boolean)isRdsConnection);
        UIUtils.setControlVisible((Control)this.rdsHostNameText, (boolean)isRdsConnection);
        boolean ssoVisible = !this.isCloudProvided && this.curConfigType.isSupportsSSO();
        UIUtils.setControlVisible((Control)this.ssoGroup, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.iamSSOCheckbox, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.ssoDocsLink, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.ssoPrefLink, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.use3rdPartyAccessCheckbox, (!this.isCloudProvided && this.curConfigType.isSupportsAssumeRole() ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.useAwsSecretsManagerCheckbox, (this.dataSource != null && this.curConfigType.isSupportsAssumeRole() ? 1 : 0) != 0);
        boolean accountIdEnabled = !this.isCloudProvided && this.curConfigType.isSupportsAssumeRole() && this.use3rdPartyAccessCheckbox.getSelection();
        UIUtils.setControlVisible((Control)this.iamAccountIdLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamAccountIdText, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamExternalIdLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamExternalIdText, (boolean)accountIdEnabled);
        boolean secretsEnabled = this.dataSource != null && this.useAwsSecretsManagerCheckbox.getSelection();
        UIUtils.setControlVisible((Control)this.iamSecretNameLabel, (boolean)secretsEnabled);
        UIUtils.setControlVisible((Control)this.iamSecretNameText, (boolean)secretsEnabled);
        UIUtils.asyncExec(() -> {
            this.awsAccessKeyText.getShell().layout(true, true);
            UIUtils.resizeShell((Shell)this.awsAccessKeyText.getShell());
        });
    }

    public boolean isSSOEnabled() {
        return this.iamSSOCheckbox.getSelection();
    }

    protected void updateExtraIAMSettingsVisibility() {
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        this.initAuthTypes();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        DBAAuthModel authModel = configuration.getAuthModel();
        if (this.isUserNameHidden(authModel) && this.usernameLabel != null) {
            UIUtils.setControlVisible((Control)this.usernameLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.usernameText, (boolean)false);
        }
        if (!(authModel instanceof AuthModelAWSAbstract) || !((AuthModelAWSAbstract)authModel).supportsRegion() && this.regionCombo != null) {
            UIUtils.setControlVisible((Control)this.regionLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.regionCombo, (boolean)false);
        } else {
            List<String> regions = AuthModelAWSConfigurator.getPublicRegions();
            for (String region : regions) {
                this.regionCombo.add(region);
            }
            if (!CommonUtils.isEmpty((String)configuration.getAuthProperty("iam.region"))) {
                this.regionCombo.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("iam.region")));
            }
            if (this.isWide(this.regionCombo.getParent()) && this.isUserNameHidden(authModel)) {
                ((GridData)this.regionCombo.getLayoutData()).horizontalSpan = 3;
            }
        }
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        if (configuration.getAuthProperties() != null) {
            authProperties.putAll(configuration.getAuthProperties());
        }
        if (!authProperties.containsKey("iam.aws_access_key") && !CommonUtils.isEmpty((String)configuration.getUserName()) && configuration.getUserName().length() == 20) {
            authProperties.put("iam.aws_access_key", configuration.getUserName());
        }
        if (!authProperties.containsKey("iam.aws_secret_key") && !CommonUtils.isEmpty((String)configuration.getUserPassword()) && configuration.getUserPassword().length() == 40) {
            authProperties.put("iam.aws_secret_key", configuration.getUserPassword());
        }
        this.loadIAMAuthSettings(authProperties);
        if (authProperties.containsKey("iam.aws_secret_name")) {
            this.useAwsSecretsManagerCheckbox.setSelection(true);
            this.iamSecretNameText.setText((String)authProperties.get("iam.aws_secret_name"));
        }
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.awsSaveKeysCheck.setSelection(!CREDENTIALS_SAVE_RESTRICTED && dataSource.isSavePassword());
        this.updateIAMSettingsVisibility();
        this.authTypeCombo.setEnabled(!this.isCloudProvided);
        this.awsAccessKeyText.setEnabled(!this.isCloudProvided);
        this.awsSecretKeyText.setEnabled(!this.isCloudProvided);
        this.awsSessionTokenText.setEnabled(!this.isCloudProvided);
        this.regionCombo.setEnabled(!this.isCloudProvided);
        this.awsProfileNameCombo.setEnabled(!this.isCloudProvided);
        this.use3rdPartyAccessCheckbox.setEnabled(!this.isCloudProvided);
        this.iamAccountIdText.setEnabled(!this.isCloudProvided);
        this.iamExternalIdText.setEnabled(!this.isCloudProvided);
        if (!this.isCloudProvided) {
            this.enableAccessControls();
        }
        this.usernameLabel.getParent().getParent().layout(true, true);
    }

    private boolean isUserNameHidden(DBAAuthModel<?> authModel) {
        return !(authModel instanceof AuthModelAWSAbstract) || !((AuthModelAWSAbstract)authModel).supportsDatabaseUser();
    }

    public void initAuthTypes() {
        AWSAuthType[] supportedAuthTypes;
        this.authTypeCombo.removeAll();
        this.authTypes.clear();
        AWSAuthType[] aWSAuthTypeArray = supportedAuthTypes = this.getSupportedAuthTypes();
        int n = supportedAuthTypes.length;
        int n2 = 0;
        while (n2 < n) {
            AWSAuthType ct = aWSAuthTypeArray[n2];
            this.authTypes.add(ct);
            this.authTypeCombo.add(ct.getTitle());
            ++n2;
        }
        if (supportedAuthTypes.length > 0) {
            this.curConfigType = supportedAuthTypes[0];
        }
    }

    @NotNull
    public static List<String> getPublicRegions() {
        return Region.regions().stream().map(Region::id).filter(r -> !r.startsWith("aws") && !r.contains("-iso") && !r.contains("-gov")).sorted().collect(Collectors.toList());
    }

    public void loadIAMAuthSettings(Map<String, String> authProperties) {
        this.curConfigType = CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws"), (boolean)Boolean.FALSE) ? AWSAuthType.DEFAULT : (DBWorkbench.isDistributed() && CommonUtils.toBoolean((Object)authProperties.get("iam.use_session_credentials")) ? AWSAuthType.SESSION_CREDENTIALS : (CommonUtils.isNotEmpty((String)CommonUtils.toString((Object)authProperties.get("iam.profile_name"))) ? AWSAuthType.PROFILE : (CommonUtils.toBoolean((Object)CommonUtils.toString((Object)authProperties.get("iam.use_password"))) ? AWSAuthType.USER_PASSWORD : AWSAuthType.KEY)));
        this.awsAccessKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_access_key")));
        this.awsSecretKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_secret_key")));
        this.awsSessionTokenText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_session_token")));
        this.awsProfileNameCombo.setText(CommonUtils.notEmpty((String)authProperties.get("iam.profile_name")));
        this.iamAccountIdText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.account_id")));
        this.iamRoleNameText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.role_name")));
        this.rdsHostNameText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.rds_host")));
        this.iamExternalIdText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.external_id")));
        this.iamSSOCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("iam.sso_over_cli"), (boolean)Boolean.FALSE));
        this.use3rdPartyAccessCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access"), (boolean)Boolean.FALSE));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this.saveRegionSettings(props);
        this.saveIAMAuthSettings(props);
        configuration.setAuthProperties(props);
        dataSource.setSavePassword(!CREDENTIALS_SAVE_RESTRICTED && this.isSavePasswordLocally() && (!this.awsSaveKeysCheck.isVisible() || this.awsSaveKeysCheck.getSelection() || this.savePasswordCheck != null && this.savePasswordCheck.isVisible() && this.savePasswordCheck.getSelection()));
    }

    public void saveRegionSettings(Map<String, String> props) {
        if (this.regionCombo != null) {
            props.put("iam.region", this.regionCombo.getText());
        }
    }

    public void saveIAMAuthSettings(Map<String, String> props) {
        boolean use3rdPartyAccount;
        boolean useSSO;
        String roleName;
        String accountId;
        props.remove("iam.use_session_credentials");
        props.remove("iam.use_default_aws");
        props.remove("iam.aws_access_key");
        props.remove("iam.aws_secret_key");
        props.remove("iam.profile_name");
        props.remove("iam.aws_secret_name");
        props.remove("iam.account_id");
        props.remove("iam.role_name");
        props.remove("iam.rds_host");
        props.remove("iam.external_id");
        props.remove("iam.sso_over_cli");
        props.remove("iam.cross_account_access");
        if (this.curConfigType == AWSAuthType.KEY) {
            if (this.awsSaveKeysCheck.getSelection()) {
                props.put("iam.aws_access_key", this.awsAccessKeyText.getText());
                props.put("iam.aws_secret_key", this.awsSecretKeyText.getText());
                props.put("iam.aws_session_token", this.awsSessionTokenText.getText());
            }
        } else if (this.curConfigType == AWSAuthType.PROFILE) {
            props.put("iam.profile_name", this.awsProfileNameCombo.getText());
        } else if (this.curConfigType == AWSAuthType.DEFAULT) {
            props.put("iam.use_default_aws", String.valueOf(true));
        } else if (this.curConfigType == AWSAuthType.SESSION_CREDENTIALS) {
            props.put("iam.use_session_credentials", String.valueOf(true));
        } else if (this.curConfigType == AWSAuthType.USER_PASSWORD) {
            props.put("iam.use_password", String.valueOf(true));
        }
        if (this.useAwsSecretsManagerCheckbox.getSelection()) {
            props.put("iam.aws_secret_name", this.iamSecretNameText.getText());
        }
        if (!CommonUtils.isEmpty((String)(accountId = this.iamAccountIdText.getText()))) {
            props.put("iam.account_id", accountId);
        }
        if (!CommonUtils.isEmpty((String)(roleName = this.iamRoleNameText.getText()))) {
            props.put("iam.role_name", roleName);
        }
        props.put("iam.rds_host", this.rdsHostNameText.getText());
        String externalId = this.iamExternalIdText.getText();
        if (!CommonUtils.isEmpty((String)externalId)) {
            props.put("iam.external_id", externalId);
        }
        if (useSSO = this.iamSSOCheckbox.getSelection()) {
            props.put("iam.sso_over_cli", String.valueOf(true));
        }
        if (use3rdPartyAccount = this.use3rdPartyAccessCheckbox.getSelection()) {
            props.put("iam.cross_account_access", String.valueOf(true));
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        if (AWSAuthType.KEY == this.curConfigType || AWSAuthType.USER_PASSWORD == this.curConfigType) {
            return true;
        }
        if (AWSAuthType.DEFAULT == this.curConfigType || AWSAuthType.SESSION_CREDENTIALS == this.curConfigType) {
            return true;
        }
        if (AWSAuthType.PROFILE == this.curConfigType) {
            return this.awsProfileNameCombo.getSelectionIndex() >= 0;
        }
        return false;
    }

    protected boolean isForceSaveCredentials() {
        return this.staticCredentials;
    }

    public void updateControls() {
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.changeAuthType(this.curConfigType);
    }
}

