/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.SimpleCommandContext;

public class EntityEditorInput
implements IDatabaseEditorInput,
DBPDataSourceContainerProvider,
DBPContextProvider {
    private static final Log log = Log.getLog(EntityEditorInput.class);
    private final DBCExecutionContext executionContext;
    private final DBECommandContext commandContext;
    private final DBSObject object;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String defaultPageID;

    public EntityEditorInput(@Nullable DBSObject object, @Nullable DBECommandContext commandContext) {
        this.object = object;
        if (object != null) {
            this.executionContext = DBUtils.getDefaultContext((DBSObject)object, (boolean)false);
            if (this.executionContext == null) {
                log.error((Object)("Database object '" + object.getName() + "' is not associated with any execution context"));
            }
            this.commandContext = commandContext != null ? commandContext : new SimpleCommandContext(this.executionContext, false);
        } else {
            this.executionContext = null;
            this.commandContext = null;
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.executionContext != null) {
            return this.executionContext.getDataSource().getContainer();
        }
        if (this.object.getDataSource() != null) {
            return this.object.getDataSource().getContainer();
        }
        return null;
    }

    @Nullable
    public DBNDatabaseNode getNavigatorNode() {
        return null;
    }

    public DBSObject getDatabaseObject() {
        return this.object;
    }

    @Nullable
    public String getNodePath() {
        return null;
    }

    public String getDefaultPageId() {
        return this.defaultPageID;
    }

    public void setDefaultPageId(String defaultPageId) {
        this.defaultPageID = defaultPageId;
    }

    public String getDefaultFolderId() {
        return null;
    }

    @Nullable
    public Color getConnectionColor() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (container != null) {
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
        }
        return null;
    }

    @Nullable
    public DBECommandContext getCommandContext() {
        return null;
    }

    public DBPPropertySource getPropertySource() {
        return new PropertySourceCustom();
    }

    public Collection<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.attributes.remove(name);
        }
        return this.attributes.put(name, value);
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.object.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (DBSObject.class.equals(adapter)) {
            return adapter.cast(this.getDatabaseObject());
        }
        return null;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

