/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences.secrets;

import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderRegistry;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

class ProviderSelectDialog
extends BaseDialog {
    private List<DBPParametersProviderDescriptor> allProviders;
    private DBPParametersProviderDescriptor selectedProvider;

    public ProviderSelectDialog(Shell parentShell) {
        super(parentShell, "Choose provider", null);
    }

    public DBPParametersProviderDescriptor getSelectedProvider() {
        return this.selectedProvider;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        final Combo combo = UIUtils.createLabelCombo((Composite)composite, (String)"Provider", (String)"Choose secrets provider", (int)12);
        this.allProviders = DBPParametersProviderRegistry.getInstance().getAllDescriptors();
        for (DBPParametersProviderDescriptor provider : this.allProviders) {
            combo.add(provider.getLabel());
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = combo.getSelectionIndex() >= 0;
                ProviderSelectDialog.this.enableButton(0, enabled);
                ProviderSelectDialog.this.selectedProvider = enabled ? ProviderSelectDialog.this.allProviders.get(combo.getSelectionIndex()) : null;
            }
        });
        if (combo.getItemCount() > 0) {
            combo.select(0);
            this.selectedProvider = this.allProviders.get(0);
        }
        return dialogArea;
    }
}

