/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences.security;

import com.dbeaver.ui.internal.UICoreMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

class SecurityProviderPreferences {
    private final int widthHint;
    private Button bouncyCastleCheckbox;

    public SecurityProviderPreferences(@NotNull Composite parent, int widthHint) {
        this.widthHint = widthHint;
        Group providerGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.pref_page_security_group_provider, (int)1, (int)0, (int)widthHint);
        GridData gd = new GridData(32);
        gd.widthHint = 600;
        providerGroup.setLayoutData((Object)gd);
        this.addGroupLabel(providerGroup);
        this.addBouncyCastleCheckbox(providerGroup);
    }

    private void addGroupLabel(@NotNull Group group) {
        Label label = new Label((Composite)group, 64);
        label.setText(UICoreMessages.pref_page_security_text_bouncy_castle);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(this.widthHint, -1).create());
    }

    private void addBouncyCastleCheckbox(@NotNull Group group) {
        boolean enabled = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("security.jce.bc");
        this.bouncyCastleCheckbox = UIUtils.createCheckbox((Composite)group, (String)UICoreMessages.pref_page_security_check_bouncy_castle, (boolean)enabled);
    }

    void performDefaults() {
        this.bouncyCastleCheckbox.setSelection(true);
    }

    void performOk() {
        DBWorkbench.getPlatform().getPreferenceStore().setValue("security.jce.bc", this.bouncyCastleCheckbox.getSelection());
    }
}

