/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.model;

import com.dbeaver.ee.chart.model.ChartMeasurement;
import com.dbeaver.ee.chart.model.ChartValue;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;

public class SortedDatasetValuesFactory {
    private final ChartMeasurement measurement;

    public SortedDatasetValuesFactory(@NotNull ChartMeasurement measurement) {
        this.measurement = measurement;
    }

    public List<DatasetValue> getSortedValuesForDataset() {
        return this.getSortedValuesStreamForDataset().toList();
    }

    public Stream<DatasetValue> getSortedValuesStreamForDataset() {
        return this.getGroupedValues().map(entry -> new DatasetValue((Number)entry.getValue(), (Comparable)((Object)this.measurement.getTitleY()), (Comparable)entry.getKey()));
    }

    @NotNull
    private Stream<Map.Entry<String, Number>> getGroupedValues() {
        long maxSampleCount;
        Function<List, Number> listReductionFunction = this.measurement.getSampleFunction()::execute;
        Collector<ChartValue, ?, Number> valueGroupingCollector = Collectors.collectingAndThen(Collectors.mapping(ChartValue::getValue, Collectors.toList()), listReductionFunction);
        Stream<Map.Entry<String, Number>> groupedValues = this.getChartValueStream().collect(Collectors.groupingBy(ChartValue::getTitle, LinkedHashMap::new, valueGroupingCollector)).entrySet().stream();
        if (this.isSortingNeeded()) {
            groupedValues = groupedValues.sorted(this.defineNeededComparator());
        }
        if ((maxSampleCount = (long)this.measurement.getMaxSampleCount()) > 0L) {
            groupedValues = groupedValues.limit(maxSampleCount);
        }
        return groupedValues;
    }

    private boolean isSortingNeeded() {
        return this.measurement.getAxisOrderX() != IResultSetController.ColumnOrder.NONE || this.measurement.getAxisOrderY() != IResultSetController.ColumnOrder.NONE;
    }

    @NotNull
    private Comparator<Map.Entry<String, Number>> defineNeededComparator() {
        if (this.measurement.getAxisOrderX() == IResultSetController.ColumnOrder.NONE) {
            return this.getYAxisComparator();
        }
        if (this.measurement.getAxisOrderY() == IResultSetController.ColumnOrder.NONE) {
            return this.getXAxisComparator();
        }
        return this.getYAxisComparator().thenComparing(this.getXAxisComparator());
    }

    @NotNull
    private Comparator<Map.Entry<String, Number>> getXAxisComparator() {
        Comparator<Map.Entry<String, Number>> comparator = Map.Entry.comparingByKey();
        if (this.measurement.getAxisOrderX() == IResultSetController.ColumnOrder.DESC) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    @NotNull
    private Comparator<Map.Entry<String, Number>> getYAxisComparator() {
        Comparator comparator = (n1, n2) -> {
            int n;
            Number number;
            Number number2 = number = n1;
            int n3 = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, BigInteger.class, BigDecimal.class}, (Object)number2, n3)) {
                    case 0: {
                        Long l1 = (Long)number;
                        if (!(n2 instanceof Long)) {
                            number2 = number;
                            n3 = 1;
                            continue block6;
                        }
                        Long l2 = (Long)n2;
                        n = Long.compare(l1, l2);
                        break block6;
                    }
                    case 1: {
                        BigInteger bi1 = (BigInteger)number;
                        if (!(n2 instanceof BigInteger)) {
                            number2 = number;
                            n3 = 2;
                            continue block6;
                        }
                        BigInteger bi2 = (BigInteger)n2;
                        n = bi1.compareTo(bi2);
                        break block6;
                    }
                    case 2: {
                        BigDecimal bd1 = (BigDecimal)number;
                        if (!(n2 instanceof BigDecimal)) {
                            number2 = number;
                            n3 = 3;
                            continue block6;
                        }
                        BigDecimal bd2 = (BigDecimal)n2;
                        n = bd1.compareTo(bd2);
                        break block6;
                    }
                    case -1: {
                        if (n2 == null) {
                            n = 0;
                            break block6;
                        }
                        n = -1;
                        break block6;
                    }
                    default: {
                        n = n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue());
                    }
                }
                break;
            }
            return n;
        };
        if (this.measurement.getAxisOrderY() == IResultSetController.ColumnOrder.DESC) {
            comparator = comparator.reversed();
        }
        return Map.Entry.comparingByValue(comparator);
    }

    @NotNull
    private Stream<ChartValue> getChartValueStream() {
        Stream<ChartValue> values = this.measurement.getValues().stream();
        long maxRowCount = this.measurement.getMaxRowCount();
        if (maxRowCount > 0L) {
            values = values.limit(maxRowCount);
        }
        return values;
    }

    public record DatasetValue(@NotNull Number value, @NotNull Comparable rowKey, @NotNull Comparable columnKey) {
    }
}

