/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.handlers;

import com.dbeaver.ui.editors.erd.model.ERDEditableModelAdapter;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDModelAdapter;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ToggleEditModeHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(ToggleEditModeHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ERDEditorPart erdEditor = (ERDEditorPart)RuntimeUtils.getObjectAdapter((Object)activeEditor, ERDEditorPart.class);
        if (erdEditor == null) {
            return null;
        }
        ERDModelAdapter modelAdapter = erdEditor.getDiagram().getModelAdapter();
        if (modelAdapter instanceof ERDEditableModelAdapter) {
            ((ERDEditableModelAdapter)modelAdapter).setEditMode(!modelAdapter.supportsModelEdit());
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        ERDEditorPart erdEditor = (ERDEditorPart)RuntimeUtils.getObjectAdapter((Object)activeEditor, ERDEditorPart.class);
        if (erdEditor == null) {
            return;
        }
        ERDModelAdapter modelAdapter = erdEditor.getDiagram().getModelAdapter();
        if (modelAdapter instanceof ERDEditableModelAdapter) {
            element.setChecked(modelAdapter.supportsModelEdit());
        }
    }
}

