/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.ortho;

import com.dbeaver.ui.editors.erd.figures.BridgeFigure;
import com.dbeaver.ui.editors.erd.ortho.OrthoPathUtils;
import com.dbeaver.ui.editors.erd.ortho.OrthogonalIntersection;
import com.dbeaver.ui.editors.erd.ortho.RouteLine;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.editors.erd.connector.ERDConnection;
import org.jkiss.dbeaver.ui.editors.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ui.editors.erd.figures.AttributeListFigure;
import org.jkiss.dbeaver.ui.editors.erd.figures.EntityFigure;

public class OrthogonalConnection
extends ERDConnection {
    private static final int LINE_WIDTH_DEFAULT = 1;
    private static final int LINE_WIDTH_SELECTED = 3;
    private static final int TOLERANCE = 2;
    private static final boolean IS_DEBUG_MODE = false;
    private static final double ROUNDED_RADIUS = 7.0;
    private List<RouteLine> overlappingLinesByX = new ArrayList<RouteLine>();
    private List<RouteLine> overlappingLinesByY = new ArrayList<RouteLine>();
    private List<RouteLine> helperlines = new ArrayList<RouteLine>();

    protected void outlineShape(Graphics g) {
        this.drawTraceLine(g);
    }

    private void drawFirstPoint(@NotNull Graphics g, @NotNull Point firstPoint) {
        g.setBackgroundColor(ColorConstants.red);
        g.setForegroundColor(ColorConstants.red);
        g.setLineWidth(2);
        g.fillOval(firstPoint.x - 3, firstPoint.y - 3, 6, 6);
    }

    private void drawTraceLine(@NotNull Graphics g) {
        g.setBackgroundColor(ColorConstants.cyan);
        g.setForegroundColor(ColorConstants.green);
        g.setLineWidth(2);
        for (RouteLine routeLine : this.helperlines) {
            g.drawLine(routeLine.getFirst(), routeLine.getLast());
            g.fillOval(routeLine.getLast().x - 2, routeLine.getLast().y - 2, 4, 4);
            g.fillOval(routeLine.getFirst().x - 2, routeLine.getFirst().y - 2, 4, 4);
        }
    }

    private void drawRoute(@NotNull Graphics g, PointList points) {
        Point p = points.getFirstPoint();
        g.setBackgroundColor(ColorConstants.red);
        g.fillOval(p.x - 2, p.y - 2, 4, 4);
        g.drawText(String.valueOf(0), p.x - 5, p.y - 15);
        g.setBackgroundColor(ColorConstants.lightGreen);
        int i = 0;
        while (i < points.size() - 1) {
            p = points.getPoint(i);
            g.fillOval(p.x - 2, p.y - 2, 4, 4);
            g.drawOval(p.x - 2, p.y - 2, 4, 4);
            g.drawText(String.valueOf(i), p.x - 5, p.y - 15);
            g.drawText(String.valueOf(p.x), p.x - 15, p.y - 35);
            ++i;
        }
        g.setBackgroundColor(ColorConstants.blue);
        p = points.getLastPoint();
        g.fillOval(p.x - 2, p.y - 2, 4, 4);
        g.drawText(String.valueOf(points.size()), p.x - 5, p.y - 15);
        g.setBackgroundColor(ColorConstants.orange);
    }

    private PointList transformToBeizer(Graphics g, PointList points) {
        PointList beizerPointList = new PointList();
        int i = 1;
        while (i < points.size()) {
            Point p0 = points.getPoint(i - 1);
            Point cornerPoint = points.getPoint(i);
            if (i + 1 < points.size()) {
                Point p2 = points.getPoint(i + 1);
                RouteLine line1 = new RouteLine(p0, cornerPoint);
                RouteLine line2 = new RouteLine(cornerPoint, p2);
                if (cornerPoint.x == p0.x && cornerPoint.x == p2.x) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    beizerPointList.addPoint(cornerPoint);
                } else if (cornerPoint.y == p0.y && cornerPoint.y == p2.y) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    beizerPointList.addPoint(cornerPoint);
                } else if (cornerPoint.x == p0.x && cornerPoint.y == p2.y || cornerPoint.y == p0.y && cornerPoint.x == p2.x) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    boolean isIntersects = false;
                    for (RouteLine line : this.overlappingLinesByY) {
                        if (!OrthoPathUtils.polylineContainsPoint(line, cornerPoint)) continue;
                        isIntersects = true;
                        break;
                    }
                    if (line1.getLength() < 20.0 || line2.getLength() < 20.0) {
                        beizerPointList.addPoint(cornerPoint);
                    } else if (isIntersects || i == points.size() - 2) {
                        int dx1 = (int)(Math.cos(line1.getAngel()) * 7.0);
                        int dy1 = (int)(Math.sin(line1.getAngel()) * 7.0);
                        int dx2 = (int)(Math.cos(line2.getAngel()) * 7.0);
                        int dy2 = (int)(Math.sin(line2.getAngel()) * 7.0);
                        Point p01 = new Point(cornerPoint.x - dx1, cornerPoint.y - dy1);
                        Point p02 = new Point(cornerPoint.x + dx2, cornerPoint.y + dy2);
                        PointList corner = new PointList();
                        corner.addPoint(p01);
                        corner.addPoint(cornerPoint);
                        corner.addPoint(p02);
                        beizerPointList.addPoint(p01);
                        beizerPointList.addPoint(p02);
                    } else {
                        beizerPointList.addPoint(cornerPoint);
                    }
                }
            } else {
                beizerPointList.addPoint(cornerPoint);
            }
            ++i;
        }
        return beizerPointList;
    }

    private PointList getBezierPoints(PointList controlPoints) {
        if (controlPoints.size() >= 3) {
            int index = 0;
            PointList pointList = new PointList();
            Point p0 = controlPoints.getPoint(index++);
            Point p1 = controlPoints.getPoint(index++);
            Point p2 = null;
            Point nextPoint = controlPoints.getPoint(index++);
            while (true) {
                p2 = nextPoint;
                double t = 0.0;
                while (t <= 1.0) {
                    Point point = new Point();
                    point.x = (int)((double)p0.x * (1.0 - t) * (1.0 - t) + (double)(2 * p1.x) * t * (1.0 - t) + (double)p2.x * t * t);
                    point.y = (int)((double)p0.y * (1.0 - t) * (1.0 - t) + (double)(2 * p1.y) * t * (1.0 - t) + (double)p2.y * t * t);
                    pointList.addPoint(point);
                    t += 0.01;
                }
                pointList.addPoint(p2);
                if (index == controlPoints.size()) break;
                p0 = p2;
                p1 = nextPoint;
                nextPoint = controlPoints.getPoint(index++);
            }
            return pointList;
        }
        return controlPoints;
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint((PointList)this.getBezierPoints(this.getPoints()), (int)x, (int)y, (int)2);
    }

    public void cleanupOverlappedPoints() {
        this.overlappingLinesByY.clear();
        this.overlappingLinesByX.clear();
    }

    public void revalidate() {
        super.revalidate();
        if (this.overlappingLinesByY != null) {
            this.overlappingLinesByY.clear();
        }
        if (this.overlappingLinesByX != null) {
            this.overlappingLinesByX.clear();
        }
        if (this.helperlines != null) {
            this.helperlines.clear();
        }
    }

    public List<RouteLine> getOverlappingLinesByY() {
        return this.overlappingLinesByY;
    }

    public void setOverlappingLinesByY(List<RouteLine> overlappingLinesByY) {
        this.overlappingLinesByY = overlappingLinesByY;
    }

    public List<RouteLine> getOverlappingLinesByX() {
        return this.overlappingLinesByX;
    }

    public void setOverlappingLinesByX(List<RouteLine> overlappingLinesByX) {
        this.overlappingLinesByX = overlappingLinesByX;
    }

    public void addTarceLine(List<RouteLine> startLines) {
        if (startLines != null) {
            this.helperlines.addAll(startLines);
        }
    }

    public String toString() {
        IFigure srcOwner = this.getSourceAnchor().getOwner();
        IFigure trgOwner = this.getTargetAnchor().getOwner();
        if (srcOwner instanceof AttributeItemFigure) {
            AttributeItemFigure srcAttribute = (AttributeItemFigure)srcOwner;
            if (trgOwner instanceof AttributeListFigure) {
                AttributeListFigure trgAttributeList = (AttributeListFigure)trgOwner;
                IFigure iFigure = srcAttribute.getParent().getParent();
                if (iFigure instanceof EntityFigure) {
                    EntityFigure srcEntity = (EntityFigure)iFigure;
                    IFigure iFigure2 = trgAttributeList.getParent();
                    if (iFigure2 instanceof EntityFigure) {
                        EntityFigure trgEntity = (EntityFigure)iFigure2;
                        return "Ortho Connection: " + srcEntity.getPart().getName() + "::" + srcAttribute.getLabel().getText() + " --> " + trgEntity.getPart().getName() + "::" + ((AttributeItemFigure)trgAttributeList.getAttributes().get(0)).getLabel().getText();
                    }
                }
            }
        }
        return super.toString();
    }

    public void createBridges(@NotNull List<OrthogonalIntersection> intersections) {
        for (OrthogonalIntersection intersection : intersections) {
            BridgeFigure figure = new BridgeFigure(intersection.getLine().getAngelDegrees());
            figure.setLocation(new Point(intersection.getPoint().x - 5, intersection.getPoint().y - 5));
            this.add((IFigure)figure);
        }
    }

    public void clearBridges() {
        this.getChildrenRevIterable().forEach(child -> {
            if (child instanceof BridgeFigure) {
                BridgeFigure bridge = (BridgeFigure)((Object)child);
                this.remove((IFigure)bridge);
            }
        });
    }

    public void setSelected(boolean hightlight) {
        int lineSelectionWidth = 1;
        if (hightlight) {
            lineSelectionWidth = 3;
        }
        for (IFigure child : this.getChildren()) {
            if (child instanceof Polyline) {
                Polyline line = (Polyline)child;
                line.setLineWidth(lineSelectionWidth);
                continue;
            }
            if (!(child instanceof BridgeFigure)) continue;
            BridgeFigure shape = (BridgeFigure)child;
            shape.setBridgeWidth(lineSelectionWidth);
        }
    }
}

