/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.commands;

import com.dbeaver.model.sql.SQLCommandParameters;
import com.dbeaver.model.sql.SQLCommandUtils;
import com.dbeaver.ui.editors.sql.SQLUIMessages;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DesktopUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.commands.SQLCommandSet;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenPredicateEvaluator;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateFactory;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicatesCondition;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.utils.CommonUtils;

public class SQLCommandAccept
implements SQLControlCommandHandler {
    private static Map<String, String> parseParameters(DBPDataSource dataSource, String parametersText) {
        TPToken token;
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules(dataSource, false);
        TokenPredicateFactory tt = TokenPredicateFactory.makeDialectSpecificFactory((SQLRuleManager)ruleManager);
        TokenPredicateSet parsingPredicates = TokenPredicateSet.of((TokenPredicatesCondition[])new TokenPredicatesCondition[]{SQLCommandUtils.makeAcceptCommandPredicate((TokenPredicateFactory)tt)});
        SQLTokenPredicateEvaluator predicateEvaluator = new SQLTokenPredicateEvaluator((SQLTokenPredicateSet)parsingPredicates);
        TPRuleBasedScanner scanner = new TPRuleBasedScanner();
        scanner.setRules(ruleManager.getAllRules());
        Document document = new Document(parametersText);
        scanner.setRange((IDocument)document, 0, document.getLength());
        Map result = null;
        do {
            SQLTokenType sQLTokenType;
            token = scanner.nextToken();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (token instanceof TPTokenDefault) {
                TPTokenDefault tokenDefault = (TPTokenDefault)token;
                sQLTokenType = (SQLTokenType)tokenDefault.getData();
            } else {
                sQLTokenType = SQLTokenType.T_OTHER;
            }
            SQLTokenType tokenType = sQLTokenType;
            try {
                if (tokenLength <= 0 || token.isWhitespace()) continue;
                String tokenText = document.get(tokenOffset, tokenLength);
                predicateEvaluator.captureToken((TokenEntry)new SQLTokenEntry(tokenText, tokenType, false));
                predicateEvaluator.evaluatePredicates();
                result = predicateEvaluator.obtainPrefixCaptures();
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        } while (!token.isEOF());
        return result;
    }

    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        String valueString;
        boolean isValid;
        DBCExecutionContext executionContext = scriptContext.getExecutionContext();
        if (executionContext == null) {
            throw new DBCException("No execution context");
        }
        DBPDataSource dataSource = executionContext.getDataSource();
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        Map<String, String> params = command.getParameters();
        if (params == null && (params = SQLCommandAccept.parseParameters(dataSource, command.getText().replaceAll("^@@?", ""))) == null) {
            throw new DBCException("Ill-formed ACCEPT command");
        }
        String varName = (String)params.get("com.dbeaver.ui.editors.sql.commands.CommandParameters.Accept.variable");
        String optionalType = params.get("com.dbeaver.ui.editors.sql.commands.CommandParameters.Accept.type");
        String optionalFormatString = params.get("com.dbeaver.ui.editors.sql.commands.CommandParameters.Accept.format");
        String optionalDefaultString = params.get("com.dbeaver.ui.editors.sql.commands.CommandParameters.Accept.default");
        String optionalPromptString = params.get("com.dbeaver.ui.editors.sql.commands.CommandParameters.Accept.prompt");
        String optionalPrompt = optionalPromptString == null ? null : sqlDialect.getUnquotedString(optionalPromptString).trim();
        String prompt = CommonUtils.isNotEmpty((String)optionalPromptString) ? optionalPrompt : NLS.bind((String)SQLUIMessages.sqlCommand_accept_default_prompt, (Object)varName);
        String optionalDefault = optionalDefaultString == null ? null : sqlDialect.getUnquotedString(optionalDefaultString).trim();
        do {
            isValid = true;
            valueString = DesktopUI.getInstance().promptProperty(prompt, optionalDefault);
            if (valueString == null) {
                throw new DBCException("Command cancelled by the user");
            }
            if (optionalType == null) continue;
            SQLCommandParameters.Accept.ValueType valueType = Arrays.stream(SQLCommandParameters.Accept.ValueType.values()).filter(vt -> vt.predefinedTypeName.equalsIgnoreCase(optionalType)).findFirst().orElse(null);
            DBSDataType dataType = DBUtils.getLocalDataType((DBPDataSource)dataSource, (String)(valueType != null ? valueType.predefinedTypeName : optionalType));
            if (dataType != null) {
                DBDValueHandler valueHandler = DBUtils.findValueHandler((DBPDataSource)scriptContext.getExecutionContext().getDataSource(), (DBSTypedObject)dataType);
                try {
                    Throwable throwable = null;
                    Object var22_24 = null;
                    try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Load Instance Parameters");){
                        valueHandler.getValueFromObject(session, (DBSTypedObject)dataType, (Object)valueString, true, true);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBCException e) {
                    DesktopUI.getInstance().showError("Illegal value", dataType.getTypeName() + " is expected", (Throwable)e);
                    isValid = false;
                }
                continue;
            }
            throw new DBCException("Illegal value type specified: " + optionalType);
        } while (!isValid);
        String preparedVarName = SQLCommandSet.prepareVarName((SQLDialect)sqlDialect, (String)varName);
        scriptContext.setVariable(preparedVarName, (Object)valueString);
        return SQLControlResult.success();
    }
}

