/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.ui.license.LicenseImportDialog;
import com.dbeaver.ui.license.LicenseInfoDialog;
import com.dbeaver.ui.license.LicenseUIUtils;
import com.dbeaver.ui.license.internal.LMUIMessages;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class LicenseManagementDialog
extends BaseDialog {
    private static final Log log = Log.getLog(LicenseManagementDialog.class);
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int DELETE_BUTTON_ID = 1001;
    public static final int REFRESH_BUTTON_ID = 1002;
    private Table licTable;

    public LicenseManagementDialog(Shell parentShell) {
        super(parentShell, LMUIMessages.dialog_area_title_text_license_management, null);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite infoComposite = UIUtils.createPlaceholder((Composite)composite, (int)2);
        infoComposite.setLayoutData((Object)new GridData(768));
        LMProduct activeProduct = LMAppUtils.getActiveProduct();
        UIUtils.createLabelText((Composite)infoComposite, (String)LMUIMessages.dialog_area_label_text_active_product, (String)(activeProduct.getName() + " (" + activeProduct.getVersion() + ")"), (int)2056);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)LMUIMessages.dialog_area_control_group_licenses, (int)1, (int)1808, (int)0);
        this.licTable = new Table((Composite)group, 67584);
        this.licTable.setHeaderVisible(true);
        this.licTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licTable.getHeaderHeight() * 6;
        this.licTable.setLayoutData((Object)gd);
        this.licTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem[] selection = LicenseManagementDialog.this.licTable.getSelection();
                if (selection.length == 1) {
                    LMLicense license = (LMLicense)selection[0].getData();
                    LicenseInfoDialog infoDialog = new LicenseInfoDialog(LicenseManagementDialog.this.getShell());
                    infoDialog.setViewLicense(license);
                    infoDialog.open();
                }
            }
        });
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)"ID");
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_type);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_version);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_subject);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_email);
        TableColumn column = UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_issue_date);
        column.setToolTipText(LMUIMessages.dialog_area_table_column_issue_date_tip);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_end_time);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_label_text_users);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_label_text_support_period);
        UIUtils.createTableColumn((Table)this.licTable, (int)16384, (String)LMUIMessages.dialog_area_table_column_state);
        this.refreshLicenseTable();
        return parent;
    }

    private void refreshLicenseTable() {
        this.licTable.removeAll();
        try {
            DBPLicenseService licenseService = LMAppUtils.getLicenseService();
            LMLicense[] licenses = licenseService.getAllProductLicenses();
            if (licenses != null) {
                LMLicense[] lMLicenseArray = licenses;
                int n = licenses.length;
                int n2 = 0;
                while (n2 < n) {
                    LMLicense license = lMLicenseArray[n2];
                    LMSubscription subscription = null;
                    if (license.isSubscription()) {
                        subscription = licenseService.getSubscriptionInfo(license);
                    }
                    TableItem item = new TableItem(this.licTable, 0);
                    item.setData((Object)license);
                    item.setText(0, license.getLicenseId());
                    item.setText(1, license.getLicenseTypeFull());
                    item.setText(2, license.getProductVersion());
                    item.setText(3, CommonUtils.notEmpty((String)license.getOwnerFull()));
                    item.setText(4, CommonUtils.notEmpty((String)license.getOwnerEmail()));
                    item.setText(5, LMUtils.HR_DATE_FORMAT.format(license.getLicenseIssueTime()));
                    Date licenseEndTime = license.getLicenseEndTime();
                    if (subscription != null) {
                        licenseEndTime = subscription.getExpirationDate();
                    }
                    item.setText(6, licenseEndTime == null ? LMUIMessages.dialog_area_column_text_perpetual : LMUtils.HR_DATE_FORMAT.format(licenseEndTime));
                    item.setText(7, LicenseUIUtils.getLicenseUserNumber(license));
                    item.setText(8, LicenseUIUtils.getLicenseSupportPeriod(license));
                    item.setText(9, licenseService.getLicenseStatus(license));
                    ++n2;
                }
            }
        }
        catch (LMException e) {
            DBWorkbench.getPlatformUI().showError("Error reading license info", " Error while reading license info from license service", (Throwable)e);
        }
        UIUtils.packColumns((Table)this.licTable);
    }

    protected void createButtonsForLeftButtonBar(@NotNull Composite parent) {
        if (!DBWorkbench.isDistributed()) {
            Button refreshButton = this.createButton(parent, 1002, "Refresh from server", false);
            ((GridData)refreshButton.getLayoutData()).horizontalAlignment = 1;
        }
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 1000, LMUIMessages.dialog_area_button_import, false);
        this.createButton(parent, 1001, LMUIMessages.dialog_area_button_delete, false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            DBPLicenseService licenseService = LMAppUtils.getLicenseService();
            LMLicense activeLicense = null;
            try {
                activeLicense = licenseService.getActiveProductLicense(false);
            }
            catch (LMException e) {
                log.error((Object)e);
                DBWorkbench.getPlatformUI().showError("Can't load active license", e.getMessage(), (Throwable)e);
            }
            LicenseImportDialog importDialog = new LicenseImportDialog(this.getShell());
            if (importDialog.open() == 0) {
                this.refreshLicenseTable();
            }
            LMLicense newLicense = null;
            try {
                newLicense = licenseService.getActiveProductLicense(false);
            }
            catch (LMException e) {
                log.error((Object)e);
                DBWorkbench.getPlatformUI().showError("Can't load active license", e.getMessage(), (Throwable)e);
            }
            if (activeLicense != null && newLicense != null && activeLicense.getLicenseType().getId() != newLicense.getLicenseType().getId()) {
                DBWorkbench.getPlatformUI().showMessageBox(LMUIMessages.dialog_import_license_restart_title, LMUIMessages.dialog_import_license_restart_message, false);
                PlatformUI.getWorkbench().restart();
            }
            return;
        }
        if (buttonId == 1001) {
            try {
                this.deleteSelectedLicense();
            }
            catch (LMException e) {
                DBWorkbench.getPlatformUI().showError("Delete license", "Error deleting license", (Throwable)e);
            }
            this.refreshLicenseTable();
            return;
        }
        if (buttonId == 1002) {
            if (this.licTable.getItemCount() == 0) {
                return;
            }
            try {
                this.refreshLicensesFromServer();
                UIUtils.showMessageBox((Shell)this.getShell(), (String)"All fine", (String)"All licenses were updated from server", (int)2);
            }
            catch (LMException e) {
                DBWorkbench.getPlatformUI().showError("Refresh licenses", "There were some errors while refreshing license(s)", (Throwable)e);
            }
            this.refreshLicenseTable();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void deleteSelectedLicense() throws LMException {
        TableItem[] tableItemArray = this.licTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LMLicense license = (LMLicense)item.getData();
            if (license.getLicenseType() == LMLicenseType.TRIAL) {
                MessageBox errorBox = new MessageBox(this.getShell(), 1);
                errorBox.setText("Delete license");
                errorBox.setMessage("You can't delete trial license.");
                errorBox.open();
            } else {
                MessageBox confirm = new MessageBox(this.getShell(), 194);
                confirm.setText("Delete license");
                confirm.setMessage("Are you sure you want to delete license '" + license.getLicenseId() + "'?\nYou won't be able to undo this operation although you can import this license again.");
                if (confirm.open() == 64) {
                    LMAppUtils.getLicenseService().deleteLicense(license);
                    this.licTable.remove(this.licTable.indexOf(item));
                }
            }
            ++n2;
        }
    }

    private void refreshLicensesFromServer() throws LMException {
        LMException lastError = null;
        TableItem[] tableItemArray = this.licTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LMLicense license = (LMLicense)item.getData();
            try {
                LMLicense refreshedLicense = LMAppUtils.getLicenseService().refreshProductLicense(license);
                if (refreshedLicense != null) {
                    item.setData((Object)refreshedLicense);
                }
            }
            catch (LMException e) {
                if (lastError != null) {
                    log.error((Object)("Error refreshing license: " + lastError.getMessage()));
                }
                lastError = e;
            }
            ++n2;
        }
        if (lastError != null) {
            throw lastError;
        }
    }
}

