/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.action.HideUnusedColumnsAction;
import com.dbeaver.ee.vqb.ui.editor.VQBContentProvider;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorDecorator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.handlers.VQBNavigationHandler;
import com.dbeaver.ee.vqb.ui.part.QueryColumnPart;
import com.dbeaver.ee.vqb.ui.part.QueryJoinPart;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.builder.VQBQueryParser;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.erd.ERDContentProvider;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.erd.command.BendpointCommand;
import org.jkiss.dbeaver.ui.editors.erd.command.NodeMoveCommand;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorContextMenuProvider;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VQBEditorPart
extends ERDEditorPart {
    private static final Log log = Log.getLog(VQBEditorPart.class);
    @NotNull
    private final VQBEditorPresentation presentation;
    @Nullable
    private volatile VQBQueryInfo queryInfo;
    @NotNull
    private final QueryGeneratorJob generatorJob = new QueryGeneratorJob();
    private final Object syncRoot = new Object();
    private boolean expectingReloadDecision = false;

    VQBEditorPart(@NotNull VQBEditorPresentation presentation) {
        this.presentation = presentation;
    }

    @NotNull
    public VQBEditorPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.presentation.getSQLEditor().getDataSource();
    }

    public boolean isReadOnly() {
        DBPProject project = this.getDiagramProject();
        return !project.hasRealmPermission("project-resource-edit");
    }

    protected void installKeyHandler(GraphicalViewer viewer) {
        viewer.setKeyHandler((KeyHandler)new VQBNavigationHandler(viewer));
    }

    protected boolean hasProgressControl() {
        return false;
    }

    public boolean isERD() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite vqbHolder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        if (parent.getLayout() instanceof GridLayout) {
            vqbHolder.setLayoutData((Object)new GridData(1808));
        }
        Composite erdHolder = UIUtils.createPlaceholder((Composite)vqbHolder, (int)1);
        erdHolder.setLayout((Layout)new FillLayout());
        erdHolder.setLayoutData((Object)new GridData(1808));
        super.createPartControl(erdHolder);
        ToolBarManager tb = new ToolBarManager();
        tb.add((IContributionItem)new Separator());
        tb.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new HideUnusedColumnsAction(this), (boolean)false));
        tb.add((IContributionItem)new Separator());
        this.fillDefaultEditorContributions((IContributionManager)tb);
        ToolBar toolBar = tb.createControl(vqbHolder);
        toolBar.setLayoutData((Object)new GridData(128));
        this.getCommandStack().addCommandStackEventListener(commandStackEvent -> {
            switch (commandStackEvent.getDetail()) {
                case 8: 
                case 16: 
                case 32: {
                    Command command = commandStackEvent.getCommand();
                    if (command instanceof NodeMoveCommand || command instanceof BendpointCommand) break;
                    this.processQueryChangeCommand(command);
                }
            }
        });
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.getSite(), (Control)this.getGraphicalControl());
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.getGraphicalControl(), (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    protected void fillConfigurationContribution(IContributionManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("configuration"));
        Action configAction = new Action(VQBMessages.editor_control_action_configuration){

            public void run() {
                UIUtils.showPreferencesFor((Shell)VQBEditorPart.this.getSite().getShell(), (Object)((Object)VQBEditorPart.this), (String[])new String[]{"com.dbeaver.preferences.erd.general"});
                VQBEditorPart.this.getDiagram().setAttributeStyles(ERDViewStyle.getDefaultStyles((DBPPreferenceStore)VQBUIActivator.getDefault().getPreferences()));
                VQBEditorPart.this.refreshEntityAndAttributes();
                VQBEditorPart.this.refreshDiagram(true, true);
            }
        };
        configAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PANEL_CUSTOMIZE));
        toolBarManager.add((IAction)configAction);
    }

    public void doSave(IProgressMonitor monitor) {
        log.error((Object)"Save not supported in VQB");
    }

    private void processQueryChangeCommand(Command command) {
        this.scheduleQueryGenerator();
    }

    public Object getAdapter(Class adapter) {
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "VQB Editor";
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void scheduleQueryGenerator() {
        this.generatorJob.schedule(100L);
    }

    protected void registerDropTargetListeners(GraphicalViewer viewer) {
        super.registerDropTargetListeners(viewer);
    }

    protected ERDContentProvider createContentProvider() {
        return new VQBContentProvider(this);
    }

    protected ERDDecorator createDecorator() {
        return new VQBEditorDecorator(this);
    }

    protected void loadDiagram(boolean refreshMetadata) {
        VQBQueryInfo qi = this.queryInfo;
        if (qi == null || qi.getQuery() == null || CommonUtils.isEmpty((String)qi.getQuery().getText())) {
            this.setErrorMessage("No Active Query.\nDrag-and-drop tables from the database navigator or use the palette.\nDrag-n-drop columns to join tables.");
        }
        this.loadDiagramFromQuery();
    }

    @NotNull
    protected ERDEditorContextMenuProvider createContextProvider() {
        return new ERDEditorContextMenuProvider((ERDEditorPart)this, false);
    }

    @NotNull
    public DBPProject getDiagramProject() {
        return this.getPresentation().getSQLEditor().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadQuery(SQLQuery query) {
        DBCExecutionContext executionContext = this.presentation.getSQLEditor().getExecutionContext();
        if (this.isDirty()) {
            Object object = this.syncRoot;
            synchronized (object) {
                if (this.expectingReloadDecision) {
                    return;
                }
                this.expectingReloadDecision = true;
            }
            boolean doReplace = UIUtils.confirmAction((Shell)this.getSite().getShell(), (String)"Query Builder", (String)VQBMessages.editor_part_query_confirm_action_question_unsaved_changes);
            Object object2 = this.syncRoot;
            synchronized (object2) {
                try {
                    if (!doReplace) {
                        return;
                    }
                }
                finally {
                    this.expectingReloadDecision = false;
                }
            }
        }
        Statement statement = null;
        if (!CommonUtils.isEmptyTrimmed((String)query.getText())) {
            statement = query.getStatement();
            if (statement == null) {
                Throwable error = query.getParseError();
                if (error != null) {
                    error = CommonUtils.getRootCause((Throwable)error);
                    DBWorkbench.getPlatformUI().showError("Query parse failed", "Could not parse SQL query:\n" + query.getText(), error);
                }
            } else if (!(statement instanceof Select)) {
                this.setErrorMessage("Only SELECT queries are supported");
                query = new SQLQuery(query.getDataSource(), "");
                statement = null;
            } else {
                this.setErrorMessage(null);
            }
        }
        if (statement == null) {
            statement = VQBUtils.createEmptySelectStatement();
        }
        this.queryInfo = new VQBQueryInfo(executionContext, query, (Select)statement);
    }

    private void loadDiagramFromQuery() {
        if (this.getDiagramPart() == null || this.queryInfo == null) {
            return;
        }
        final DBPDataSource dataSource = this.queryInfo.getQuery().getDataSource();
        if (dataSource == null) {
            return;
        }
        this.getDiagramPart().getDiagram().clear();
        DatabaseLoadService<EntityDiagram> loadService = new DatabaseLoadService<EntityDiagram>("Parse query", dataSource){

            public EntityDiagram evaluate(@NotNull DBRProgressMonitor monitor) {
                DiagramPart diagramPart;
                EntityDiagram entityDiagram = new EntityDiagram(null, "Query Builder", VQBEditorPart.this.getContentProvider(), VQBEditorPart.this.getDecorator());
                entityDiagram.setLayoutManualAllowed(true);
                if (VQBEditorPart.this.presentation.getSQLEditor().getDataSource() == null) {
                    log.debug((Object)"Cannot load ERD - not connected to a database server");
                    return entityDiagram;
                }
                VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.queryInfo, VQBEditorPart.this.presentation.getSQLEditor().getSyntaxManager());
                try {
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> parser.loadDiagramFromQuery(monitor, (ERDDiagram)entityDiagram, VQBUIActivator.getDefault().getPreferences()));
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error in query", "SQL query can't be properly parsed", (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return entityDiagram;
                }
                monitor.worked(1);
                boolean restoreSettingsCompleted = false;
                EditPart oldContents = VQBEditorPart.this.getGraphicalViewer().getContents();
                if (oldContents instanceof DiagramPart && VQBEditorPart.this.restoreVisualSettings(diagramPart = (DiagramPart)oldContents, entityDiagram)) {
                    entityDiagram.setLayoutManualAllowed(true);
                    entityDiagram.setLayoutManualDesired(true);
                    restoreSettingsCompleted = true;
                }
                UIUtils.syncExec(() -> {
                    ERDGraphicalViewer graphicalViewer = VQBEditorPart.this.getGraphicalViewer();
                    graphicalViewer.setContents((Object)entityDiagram);
                });
                if (!restoreSettingsCompleted) {
                    UIUtils.syncExec(() -> {
                        ERDGraphicalViewer graphicalViewer = VQBEditorPart.this.getGraphicalViewer();
                        graphicalViewer.getEditor().getDiagramPart().resetArrangement();
                    });
                }
                monitor.done();
                return entityDiagram;
            }
        };
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)loadService, (ILoadVisualizer)new ERDEditorPart.DiagramLoaderVisualizer(this, (ILoadService)loadService, (Composite)this.getGraphicalControl()){

            protected void finishLoading() {
                VQBEditorPart.this.presentation.refreshStatement();
                VQBEditorPart.this.resetDirtyFlag();
            }
        });
        this.diagramLoadingJob.schedule();
    }

    @Nullable
    public VQBQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    void resetDirtyFlag() {
        this.setDirty(false);
    }

    public void markEditorDirty() {
        this.setDirty(true);
    }

    private void refreshDiagramState() {
        for (EntityPart part : this.getDiagramPart().getEntityParts()) {
            for (Object ec : part.getChildren()) {
                if (!(ec instanceof QueryColumnPart)) continue;
                ((QueryColumnPart)((Object)ec)).updateCheckState();
            }
            for (Object ec : part.getSourceConnections()) {
                if (!(ec instanceof QueryJoinPart)) continue;
                ((QueryJoinPart)((Object)ec)).updateJoinType();
            }
        }
    }

    public void fillNotationsMenu(IMenuManager menu) {
    }

    private class QueryGeneratorJob
    extends AbstractJob {
        QueryGeneratorJob() {
            super("Generate SQL query from diagram");
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (VQBEditorPart.this.getDataSource() == null || VQBEditorPart.this.getQueryInfo() == null) {
                return GeneralUtils.makeErrorStatus((String)"Can't generate query - not connected to a database");
            }
            VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.getQueryInfo());
            parser.updateDiagramFromQuery(monitor, (ERDDiagram)VQBEditorPart.this.getDiagram());
            UIUtils.asyncExec(() -> {
                VQBEditorPart.this.markEditorDirty();
                VQBEditorPart.this.refreshDiagramState();
                VQBEditorPart.this.presentation.refreshStatement();
            });
            return Status.OK_STATUS;
        }
    }
}

