/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.actions;

import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.navigator.DBNTableauConnectionRelationNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.model.tableau.tds.TDSObject;
import com.dbeaver.model.tableau.tds.TDSRelation;
import com.dbeaver.ui.tableau.actions.NavigatorHandlerAssociateDataSource;
import com.dbeaver.ui.tableau.editor.TableauCustomQueryEditor;
import com.dbeaver.ui.tableau.editor.TableauCustomQueryEditorInput;
import com.dbeaver.ui.tableau.pref.TableauConnectionEditDialog;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorObjectManager;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class TDSObjectManager
implements INavigatorObjectManager {
    private static final Log log = Log.getLog(TDSObjectManager.class);

    public int getSupportedFeatures() {
        return 1;
    }

    public void openObjectEditor(IWorkbenchWindow window, DBNObjectNode node) throws DBException {
        TDSObject object = (TDSObject)node.getNodeObject();
        if (!(node instanceof DBNTableauDataSourceConnectionNode)) {
            if (object instanceof TDSRelation) {
                DBNTableauConnectionRelationNode conNode = (DBNTableauConnectionRelationNode)node;
                TDSRelation relation = (TDSRelation)object;
                if (!relation.getConnection().isSupported()) {
                    DBWorkbench.getPlatformUI().showError("Not supported", "Connections of class '" + relation.getConnection().getConnectionClass() + "' are not supported");
                    return;
                }
                if (relation.isCustomQL()) {
                    this.openCustomSQLEditor(window, conNode, relation);
                } else {
                    this.openTableEditor(window, conNode, relation);
                }
                return;
            }
            return;
        }
        TableauConnectionEditDialog dialog = new TableauConnectionEditDialog(window.getShell(), (DBNTableauDataSourceConnectionNode)node);
        dialog.open();
    }

    private void openTableEditor(IWorkbenchWindow window, DBNTableauConnectionRelationNode node, TDSRelation relation) {
        List associatedDataSources = TBUtils.getAssociatedDataSources((DBPDataSourceRegistry)node.getOwnerProject().getDataSourceRegistry(), (TDSConnection)relation.getConnection());
        if (associatedDataSources.isEmpty()) {
            if (!NavigatorHandlerAssociateDataSource.linkConnectionWithDataSource(window.getShell(), node.getParentNode())) {
                return;
            }
            associatedDataSources = TBUtils.getAssociatedDataSources((DBPDataSourceRegistry)node.getOwnerProject().getDataSourceRegistry(), (TDSConnection)relation.getConnection());
        }
        if (associatedDataSources.isEmpty()) {
            return;
        }
        DBPDataSourceContainer dataSourceContainer = (DBPDataSourceContainer)associatedDataSources.get(0);
        UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
        if (serviceConnections == null) {
            return;
        }
        DBRProgressListener tableOpener = status -> {
            if (!status.isOK()) {
                return;
            }
            DBPDataSource dataSource = dataSourceContainer.getDataSource();
            new TableFindJob(dataSource, node, window).schedule();
        };
        if (!dataSourceContainer.isConnected()) {
            serviceConnections.connectDataSource(dataSourceContainer, tableOpener);
        } else {
            tableOpener.onTaskFinished(Status.OK_STATUS);
        }
    }

    private void openCustomSQLEditor(IWorkbenchWindow window, DBNTableauConnectionRelationNode node, TDSRelation relation) {
        try {
            TableauCustomQueryEditorInput editorInput = new TableauCustomQueryEditorInput(node);
            window.getActivePage().openEditor((IEditorInput)editorInput, TableauCustomQueryEditor.class.getName(), true, 1);
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open query editor", null, (Throwable)e);
        }
    }

    private static class TableFindJob
    extends AbstractJob {
        private final DBPDataSource dataSource;
        private final DBNTableauConnectionRelationNode relationNode;
        private final IWorkbenchWindow window;

        public TableFindJob(DBPDataSource dataSource, DBNTableauConnectionRelationNode relationNode, IWorkbenchWindow window) {
            super("Tableau table finder");
            this.dataSource = dataSource;
            this.relationNode = relationNode;
            this.window = window;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                DBCExecutionContext context;
                DBSObject tableObject;
                TDSRelation relation = this.relationNode.getNodeObject();
                String tableFQN = relation.getTable();
                String[][] quoteStrings = new String[][]{{"[", "]"}};
                SQLIdentifierDetector id = new SQLIdentifierDetector(this.dataSource.getSQLDialect(), '.', quoteStrings);
                String[] idParts = id.splitIdentifier(tableFQN);
                String objectName = DBUtils.getUnQuotedIdentifier((String)idParts[idParts.length - 1], (String[][])quoteStrings);
                String schemaName = null;
                String catalogName = null;
                if (idParts.length > 1) {
                    schemaName = DBUtils.getUnQuotedIdentifier((String)idParts[idParts.length - 2], (String[][])quoteStrings);
                }
                if (idParts.length > 2) {
                    catalogName = DBUtils.getUnQuotedIdentifier((String)idParts[idParts.length - 3], (String[][])quoteStrings);
                }
                if ((tableObject = DBUtils.getObjectByPath((DBRProgressMonitor)monitor, (DBCExecutionContext)(context = DBUtils.getDefaultContext((DBSObject)this.dataSource, (boolean)true)), (DBSObjectContainer)((DBSObjectContainer)this.dataSource), (String)catalogName, (String)schemaName, (String)objectName)) == null) {
                    throw new DBException("Cannot find table '" + tableFQN + "' in '" + this.dataSource.getContainer().getName() + "'");
                }
                DBNDatabaseNode tableNode = this.relationNode.getModel().getNodeByObject(monitor, tableObject, true);
                if (tableNode == null) {
                    log.error((Object)("Cannot find table node for " + String.valueOf(tableObject)));
                } else {
                    UIUtils.syncExec(() -> {
                        IEditorPart iEditorPart = NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)tableNode, null, (IWorkbenchWindow)this.window);
                    });
                }
            }
            catch (DBException e) {
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

