/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class MessagePopupTextCellEditor
extends TextCellEditor {
    private static final int DEFAULT_DELAY_MILLIS = 200;
    private static final RGB DEFAULT_BACKGROUND = new RGB(255, 150, 150);
    private final boolean cancelOnFocusLost;
    private DefaultToolTip errorPopup;
    private Composite outer;

    public MessagePopupTextCellEditor(Composite parent) {
        this(parent, false);
    }

    public MessagePopupTextCellEditor(Composite parent, boolean cancelOnFocusLost) {
        super(parent);
        this.cancelOnFocusLost = cancelOnFocusLost;
    }

    public MessagePopupTextCellEditor(Composite parent, int style) {
        this(parent, false, style);
    }

    public MessagePopupTextCellEditor(Composite parent, boolean cancelOnFocusLost, int style) {
        super(parent, style);
        this.cancelOnFocusLost = cancelOnFocusLost;
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected void focusLost() {
        if (this.cancelOnFocusLost) {
            if (this.isActivated()) {
                this.fireCancelEditor();
            }
        } else {
            super.focusLost();
        }
    }

    protected boolean withBorder() {
        return false;
    }

    protected Control createControl(Composite parent) {
        Control control = null;
        if ((this.getStyle() & 4) != 0 && this.withBorder()) {
            this.outer = new Composite(parent, 0);
            this.outer.setVisible(false);
            this.outer.setLayout((Layout)new BorderLayout());
            super.createControl(this.outer);
            control = this.outer;
            this.outer.setBackground(this.text.getBackground());
            this.outer.addListener(9, this::drawRectangle);
            this.text.addListener(24, event -> this.adjustSize());
        } else {
            control = super.createControl(parent);
        }
        this.errorPopup = new DefaultToolTip(control, 2, true);
        this.errorPopup.setPopupDelay(200);
        this.errorPopup.setBackgroundColor(Activator.getDefault().getResourceManager().createColor(DEFAULT_BACKGROUND));
        control.addDisposeListener(event -> this.errorPopup.hide());
        this.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    MessagePopupTextCellEditor.this.errorPopup.hide();
                    return;
                }
                Control editor = MessagePopupTextCellEditor.this.getControl();
                Point pos = editor.getSize();
                MessagePopupTextCellEditor.this.errorPopup.setText(MessagePopupTextCellEditor.this.getErrorMessage());
                pos.x = 0;
                MessagePopupTextCellEditor.this.errorPopup.show(pos);
            }

            public void cancelEditor() {
                MessagePopupTextCellEditor.this.errorPopup.hide();
            }

            public void applyEditorValue() {
                MessagePopupTextCellEditor.this.errorPopup.hide();
            }
        });
        if ((this.text.getStyle() & 4) != 0) {
            this.text.addVerifyListener(event -> {
                String string = event.text = Utils.firstLine((String)event.text);
            });
        }
        return control;
    }

    private void drawRectangle(Event event) {
        Rectangle textBounds = this.text.getBounds();
        Rectangle parentSize = this.outer.getClientArea();
        event.gc.setForeground(this.text.getForeground());
        event.gc.drawRectangle(0, 0, Math.min(textBounds.width + 4, parentSize.width) - 1, parentSize.height - 1);
    }

    private Point computeTextSize() {
        boolean isEmpty = this.text.getText().isEmpty();
        Point size = this.text.computeSize(-1, -1);
        size.x = isEmpty ? size.y : (size.x += size.y);
        return size;
    }

    private void resizeText() {
        Rectangle area = this.outer.getClientArea();
        Point size = this.computeTextSize();
        this.text.setBounds(2, 1, Math.min(size.x, area.width - 4), area.height - 2);
    }

    private void adjustSize() {
        this.resizeText();
        this.outer.redraw();
    }

    public void performDelete() {
        super.performDelete();
        if (this.outer != null) {
            this.adjustSize();
        }
    }

    public void performPaste() {
        super.performPaste();
        this.text.showSelection();
        if (this.outer != null) {
            this.adjustSize();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.outer != null) {
            this.outer.dispose();
            this.outer = null;
        }
    }

    public DefaultToolTip getToolTip() {
        return this.errorPopup;
    }

    private class BorderLayout
    extends Layout {
        private BorderLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point inner = MessagePopupTextCellEditor.this.computeTextSize();
            inner.x = wHint == -1 ? (inner.x += 4) : wHint;
            if (hHint != -1) {
                inner.y = hHint;
            }
            return inner;
        }

        protected void layout(Composite composite, boolean flushCache) {
            MessagePopupTextCellEditor.this.resizeText();
        }
    }
}

